/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.TimeControlPanel;

public class ClockControlPanel
extends TimeControlPanel {
    private IClock clock;
    private ClockAdapter clockListener;

    public ClockControlPanel(final IClock iClock) {
        if (iClock == null) {
            throw new RuntimeException("Cannot have a control panel for a null clock.");
        }
        this.clock = iClock;
        this.addTimeControlListener(new TimeControlPanel.TimeControlAdapter(){

            public void stepPressed() {
                iClock.stepClockWhilePaused();
            }

            public void playPressed() {
                iClock.start();
            }

            public void pausePressed() {
                iClock.pause();
            }
        });
        this.clockListener = new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                ClockControlPanel.this.updateStateFromClock();
            }

            public void clockPaused(ClockEvent clockEvent) {
                ClockControlPanel.this.updateStateFromClock();
            }
        };
        iClock.addClockListener(this.clockListener);
        this.updateStateFromClock();
    }

    protected void updateStateFromClock() {
        this.setPaused(this.clock.isPaused());
    }
}

