/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public class PhetLookAndFeel {
    private static final String[] types = new String[]{"Button", "CheckBox", "CheckBoxMenuItem", "ComboBox", "Dialog", "Label", "Menu", "MenuBar", "MenuItem", "OptionPane", "Panel", "RadioButton", "RadioButtonMenuItem", "Slider", "Spinner", "TabbedPane", "TextArea", "TextField", "TextPane", "ScrollBar", "Viewport"};
    private Font font;
    private Font titledBorderFont;
    private Font tabFont;
    private Color foregroundColor;
    private Color backgroundColor;
    private Color textFieldBackgroundColor = Color.white;
    private Insets insets;

    public PhetLookAndFeel() {
        this.setTabFont(new Font("Lucida Sans", 1, 18));
    }

    public void setTabFont(Font font) {
        this.tabFont = font;
    }

    public void apply() {
        this.updateDefaults();
    }

    public void updateDefaults() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        this.putDefaults(uIDefaults);
    }

    public void putDefaults(UIDefaults uIDefaults) {
        Object[] objectArray = this.constructDefaults();
        uIDefaults.putDefaults(objectArray);
    }

    private Object[] constructDefaults() {
        FontUIResource fontUIResource = null;
        FontUIResource fontUIResource2 = null;
        ColorUIResource colorUIResource = null;
        ColorUIResource colorUIResource2 = null;
        ColorUIResource colorUIResource3 = null;
        InsetsUIResource insetsUIResource = null;
        Object var7_7 = null;
        if (this.font != null) {
            fontUIResource = new FontUIResource(this.font);
        }
        if (this.titledBorderFont != null) {
            fontUIResource2 = new FontUIResource(this.titledBorderFont);
        }
        if (this.backgroundColor != null) {
            colorUIResource = new ColorUIResource(this.backgroundColor);
        }
        if (this.foregroundColor != null) {
            colorUIResource2 = new ColorUIResource(this.foregroundColor);
        }
        if (this.textFieldBackgroundColor != null) {
            colorUIResource3 = new ColorUIResource(this.textFieldBackgroundColor);
        }
        if (this.insets != null) {
            insetsUIResource = new InsetsUIResource(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < types.length; ++i) {
            String string = types[i];
            if (fontUIResource != null) {
                this.add(arrayList, string, "font", fontUIResource);
            }
            if (colorUIResource2 != null) {
                this.add(arrayList, string, "foreground", colorUIResource2);
            }
            if (colorUIResource != null) {
                this.add(arrayList, string, "background", colorUIResource);
            }
            if (insetsUIResource == null) continue;
            this.add(arrayList, string, "margin", insetsUIResource);
        }
        if (fontUIResource2 != null) {
            this.add(arrayList, "TitledBorder", "font", fontUIResource2);
        }
        if (colorUIResource3 != null) {
            this.add(arrayList, "TextField", "background", colorUIResource3);
        }
        if (var7_7 != null) {
            this.add(arrayList, "Button", "background", var7_7);
        }
        if (this.tabFont != null) {
            this.add(arrayList, "TabbedPane", "font", new FontUIResource(this.tabFont));
        }
        return arrayList.toArray();
    }

    private void add(ArrayList arrayList, String string, String string2, Object object) {
        arrayList.add(string + "." + string2);
        arrayList.add(object);
    }

    public static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(new PhetLookAndFeel().getLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
    }

    protected String getLookAndFeelClassName() {
        return UIManager.getSystemLookAndFeelClassName();
    }
}

