/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class TimeControlPanel
extends JPanel {
    private JButton playPause;
    private JButton step;
    private JPanel buttonPanel;
    private ImageIcon playIcon;
    private ImageIcon pauseIcon;
    private String playString;
    private String pauseString;
    private boolean paused = false;
    private ArrayList listeners = new ArrayList();

    public TimeControlPanel() {
        this.playString = PhetCommonResources.getInstance().getLocalizedString("Common.ClockControlPanel.Play");
        this.pauseString = PhetCommonResources.getInstance().getLocalizedString("Common.ClockControlPanel.Pause");
        String string = PhetCommonResources.getInstance().getLocalizedString("Common.ClockControlPanel.Step");
        BufferedImage bufferedImage = PhetCommonResources.getInstance().getImage("clock/Play24.gif");
        BufferedImage bufferedImage2 = PhetCommonResources.getInstance().getImage("clock/Pause24.gif");
        BufferedImage bufferedImage3 = PhetCommonResources.getInstance().getImage("clock/StepForward24.gif");
        this.playIcon = new ImageIcon(bufferedImage);
        this.pauseIcon = new ImageIcon(bufferedImage2);
        ImageIcon imageIcon = new ImageIcon(bufferedImage3);
        this.playPause = new JButton();
        this.updatePlayPauseButtonDimension();
        this.step = new JButton(string, imageIcon);
        SwingUtils.fixButtonOpacity(this.playPause);
        SwingUtils.fixButtonOpacity(this.step);
        this.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel(new FlowLayout(1));
        this.buttonPanel.add(this.playPause);
        this.buttonPanel.add(this.step);
        this.add((Component)this.buttonPanel, "Center");
        this.playPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeControlPanel.this.paused = !TimeControlPanel.this.paused;
                TimeControlPanel.this.updateButtons();
                if (TimeControlPanel.this.paused) {
                    TimeControlPanel.this.notifyPausePressed();
                } else {
                    TimeControlPanel.this.notifyPlayPressed();
                }
            }
        });
        this.step.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeControlPanel.this.notifyStepPressed();
            }
        });
        this.updateButtons();
    }

    protected void updatePlayPauseButtonDimension() {
        this.playPause.setPreferredSize(SwingUtils.getMaxDimension(this.playPause, this.playString, this.playIcon, this.pauseString, this.pauseIcon));
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
        this.updateButtons();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateButtons();
    }

    public void updateButtons() {
        this.playPause.setText(this.paused ? this.playString : this.pauseString);
        this.playPause.setIcon(this.paused ? this.playIcon : this.pauseIcon);
        this.playPause.setEnabled(this.isEnabled());
        this.step.setEnabled(this.isEnabled() && this.paused);
    }

    public void addTimeControlListener(TimeControlListener timeControlListener) {
        this.listeners.add(timeControlListener);
    }

    private void notifyStepPressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeControlListener)this.listeners.get(i)).stepPressed();
        }
    }

    private void notifyPlayPressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeControlListener)this.listeners.get(i)).playPressed();
        }
    }

    private void notifyPausePressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeControlListener)this.listeners.get(i)).pausePressed();
        }
    }

    public static class TimeControlAdapter
    implements TimeControlListener {
        public void stepPressed() {
        }

        public void playPressed() {
        }

        public void pausePressed() {
        }
    }

    public static interface TimeControlListener {
        public void stepPressed();

        public void playPressed();

        public void pausePressed();
    }
}

