/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;

public interface FrameSetup {
    public void initialize(JFrame var1);

    public static class NoOp
    implements FrameSetup {
        public void initialize(JFrame jFrame) {
        }
    }

    public static class MaxExtent
    implements FrameSetup {
        FrameSetup pre = null;

        public MaxExtent() {
        }

        public MaxExtent(FrameSetup frameSetup) {
            this.pre = frameSetup;
        }

        public void initialize(JFrame jFrame) {
            if (this.pre != null) {
                this.pre.initialize(jFrame);
            }
            int n = jFrame.getExtendedState();
            jFrame.setExtendedState(n |= 6);
        }
    }

    public static class CenteredWithSize
    implements FrameSetup {
        private int width;
        private int height;

        public CenteredWithSize(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public void initialize(JFrame jFrame) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            int n = (dimension.width - this.width) / 2;
            int n2 = (dimension.height - this.height) / 2;
            jFrame.setLocation(n, n2);
            jFrame.setSize(this.width, this.height);
        }
    }
}

