/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet;

import edu.colorado.phet.common.piccolophet.PhetRootPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;

public class PhetPCanvas
extends PSwingCanvas {
    private TransformStrategy transformStrategy;
    private ComponentAdapter resizeAdapter;
    private PhetRootPNode phetRootNode;
    private AffineTransform transform;

    public PhetPCanvas() {
        this(new ConstantTransformStrategy(new AffineTransform()));
    }

    public PhetPCanvas(Dimension dimension) {
        this(new ConstantTransformStrategy(new AffineTransform()));
        this.setTransformStrategy(new RenderingSizeStrategy(this, dimension));
    }

    public PhetPCanvas(TransformStrategy transformStrategy) {
        this.transformStrategy = transformStrategy;
        this.phetRootNode = new PhetRootPNode();
        this.getLayer().addChild(this.phetRootNode);
        this.removeInputEventListener(this.getZoomEventHandler());
        this.removeInputEventListener(this.getPanEventHandler());
        this.resizeAdapter = new ResizeAdapter();
        this.addComponentListener(this.resizeAdapter);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PhetPCanvas.this.requestFocus();
            }
        });
        this.setOpaque(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.requestFocus();
    }

    public void setTransformStrategy(TransformStrategy transformStrategy) {
        this.transformStrategy = transformStrategy;
        this.updateScale();
    }

    protected void updateScale() {
        this.phetRootNode.setWorldTransform(this.transformStrategy.getWorldTransform());
    }

    public void addScreenChild(PNode pNode) {
        this.phetRootNode.addScreenChild(pNode);
    }

    public void removeScreenChild(PNode pNode) {
        this.phetRootNode.removeChild(pNode);
    }

    public void addWorldChild(PNode pNode) {
        this.phetRootNode.addWorldChild(pNode);
    }

    public void removeWorldChild(PNode pNode) {
        try {
            this.phetRootNode.removeWorldChild(pNode);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void paintComponent(Graphics graphics) {
        this.transform = ((Graphics2D)graphics).getTransform();
        super.paintComponent(graphics);
    }

    public static class RenderingSizeStrategy
    implements TransformStrategy {
        private PhetPCanvas phetPCanvas;
        private Dimension renderingSize;

        public RenderingSizeStrategy(PhetPCanvas phetPCanvas, Dimension dimension) {
            this.phetPCanvas = phetPCanvas;
            this.renderingSize = dimension;
            phetPCanvas.addComponentListener(new ComponentAdapter(this){
                private final /* synthetic */ RenderingSizeStrategy this$0;
                {
                    this.this$0 = renderingSizeStrategy;
                }

                public void componentShown(ComponentEvent componentEvent) {
                    if (RenderingSizeStrategy.access$000(this.this$0) == null) {
                        RenderingSizeStrategy.access$100(this.this$0);
                    }
                }
            });
        }

        public AffineTransform getWorldTransform() {
            double d;
            double d2;
            if (this.renderingSize == null && this.phetPCanvas.isVisible()) {
                this.setRenderingSize();
            }
            double d3 = (d2 = this.getScaleX()) < (d = this.getScaleY()) ? d2 : d;
            d3 = d3 <= 0.0 ? 1.0 : d3;
            return AffineTransform.getScaleInstance(d3, d3);
        }

        private void setRenderingSize() {
            this.setRenderingSize(this.phetPCanvas.getSize());
        }

        public void setRenderingSize(Dimension dimension) {
            this.renderingSize = new Dimension(dimension);
        }

        private double getScaleY() {
            return (double)this.phetPCanvas.getHeight() / (double)this.renderingSize.height;
        }

        private double getScaleX() {
            return (double)this.phetPCanvas.getWidth() / (double)this.renderingSize.width;
        }

        static /* synthetic */ Dimension access$000(RenderingSizeStrategy renderingSizeStrategy) {
            return renderingSizeStrategy.renderingSize;
        }

        static /* synthetic */ void access$100(RenderingSizeStrategy renderingSizeStrategy) {
            renderingSizeStrategy.setRenderingSize();
        }
    }

    public static class ConstantTransformStrategy
    implements TransformStrategy {
        private AffineTransform affineTransform;

        public ConstantTransformStrategy(AffineTransform affineTransform) {
            this.affineTransform = affineTransform;
        }

        public AffineTransform getWorldTransform() {
            return new AffineTransform(this.affineTransform);
        }
    }

    public static interface TransformStrategy {
        public AffineTransform getWorldTransform();
    }

    protected class ResizeAdapter
    extends ComponentAdapter {
        protected ResizeAdapter() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            PhetPCanvas.this.updateScale();
        }

        public void componentShown(ComponentEvent componentEvent) {
            PhetPCanvas.this.updateScale();
        }
    }
}

