/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet;

import edu.umd.cs.piccolo.PNode;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

public class PhetRootPNode
extends PNode {
    private PNode worldNode = new PNode();
    private PNode screenNode = new PNode();

    public int indexOfChild(PNode pNode) {
        int n = super.indexOfChild(pNode);
        if (n >= 0) {
            return n;
        }
        n = super.indexOfChild(new WorldChild(pNode));
        if (n >= 0) {
            return n;
        }
        n = super.indexOfChild(new ScreenChild(pNode));
        if (n >= 0) {
            return n;
        }
        return -1;
    }

    public void addScreenChild(PNode pNode) {
        ScreenChild screenChild = new ScreenChild(pNode);
        screenChild.setTransform(this.screenNode.getTransform());
        this.addChild(screenChild);
    }

    public void removeWorldChild(PNode pNode) {
        int n = super.indexOfChild(new WorldChild(pNode));
        if (n >= 0) {
            this.removeChild(n);
        }
    }

    public void addWorldChild(PNode pNode) {
        WorldChild worldChild = new WorldChild(pNode);
        worldChild.setTransform(this.worldNode.getTransform());
        this.addChild(worldChild);
    }

    private ArrayList getChildren(Class clazz) {
        ArrayList<PNode> arrayList = new ArrayList<PNode>();
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            PNode pNode = this.getChild(i);
            if (!clazz.isAssignableFrom(pNode.getClass())) continue;
            arrayList.add(pNode);
        }
        return arrayList;
    }

    private ArrayList getWorldChildren() {
        return this.getChildren(WorldChild.class);
    }

    public void setWorldTransform(AffineTransform affineTransform) {
        this.worldNode.setTransform(affineTransform);
        this.updateWorldNodes();
    }

    protected void updateWorldNodes() {
        ArrayList arrayList = this.getWorldChildren();
        for (int i = 0; i < arrayList.size(); ++i) {
            PNode pNode = (PNode)arrayList.get(i);
            pNode.setTransform(this.worldNode.getTransformReference(true));
        }
    }

    private static class WorldChild
    extends WrapperNode {
        public WorldChild(PNode pNode) {
            super(pNode);
        }
    }

    private static class ScreenChild
    extends WrapperNode {
        public ScreenChild(PNode pNode) {
            super(pNode);
        }
    }

    private static class WrapperNode
    extends PNode {
        private PNode node;

        public WrapperNode(PNode pNode) {
            this.node = pNode;
            this.addChild(pNode);
        }

        public boolean equals(Object object) {
            return object instanceof WrapperNode && ((WrapperNode)object).node == this.node;
        }
    }
}

