/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.help;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.piccolophet.activities.OscillateActivity;
import edu.colorado.phet.common.piccolophet.nodes.BoundGraphic;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivityScheduler;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;

public class WiggleMe
extends PNode {
    private OscillateActivity oscillate;
    boolean oscillating = false;

    public WiggleMe(String string, int n, int n2) {
        if (!string.startsWith("<html>")) {
            string = "<html>" + string + "</html>";
        }
        HTMLNode hTMLNode = new HTMLNode(string);
        BoundGraphic boundGraphic = new BoundGraphic(hTMLNode, 2.0, 2.0);
        boundGraphic.setPaint(Color.yellow);
        this.addChild(boundGraphic);
        this.addChild(hTMLNode);
        this.oscillate = new OscillateActivity(this, n, n2, new Vector2D.Double(30.0, 0.0), 3.5);
        this.setOscillating(true);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.setOscillating(true);
        } else {
            this.setOscillating(false);
        }
        this.ensureActivityCorrect();
    }

    public void setOscillating(boolean bl) {
        this.oscillating = bl;
        this.ensureActivityCorrect();
    }

    protected void paint(PPaintContext pPaintContext) {
        this.ensureActivityCorrect();
        super.paint(pPaintContext);
    }

    public void ensureActivityCorrect() {
        if (this.rootSchedulerExists()) {
            if (this.oscillating && !this.isActivityRunning()) {
                this.addActivity();
            } else if (!this.oscillating && this.isActivityRunning()) {
                this.removeActivity();
            }
        }
    }

    private void removeActivity() {
        while (this.getRoot().getActivityScheduler().getActivitiesReference().contains(this.oscillate)) {
            this.getRoot().getActivityScheduler().removeActivity(this.oscillate);
        }
    }

    private boolean isActivityRunning() {
        if (!this.rootSchedulerExists()) {
            return false;
        }
        PActivityScheduler pActivityScheduler = this.getRoot().getActivityScheduler();
        return pActivityScheduler.getActivitiesReference().contains(this.oscillate);
    }

    private boolean rootSchedulerExists() {
        boolean bl = this.getRoot() != null && this.getRoot().getActivityScheduler() != null;
        return bl;
    }

    private void addActivity() {
        if (!this.getRoot().getActivityScheduler().getActivitiesReference().contains(this.oscillate)) {
            this.getRoot().getActivityScheduler().addActivity(this.oscillate);
        }
    }
}

