/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class HTMLNode
extends PNode {
    private static final Font DEFAULT_FONT = new Font("Lucida Sans", 1, 12);
    private static final Color DEFAULT_HTML_COLOR = Color.BLACK;
    private String html;
    private Font font;
    private Color htmlColor;
    private JLabel htmlLabel;
    private View htmlView;
    private Rectangle htmlBounds;

    public HTMLNode() {
        this(null, DEFAULT_FONT, DEFAULT_HTML_COLOR);
    }

    public HTMLNode(String string) {
        this(string, DEFAULT_FONT, DEFAULT_HTML_COLOR);
    }

    public HTMLNode(String string, Font font, Color color) {
        this.html = string;
        this.font = font;
        this.htmlColor = color;
        this.htmlLabel = new JLabel();
        this.update();
    }

    public void setHTML(String string) {
        if (this.html != null && string == null || this.html == null && string != null || !this.html.equals(string)) {
            this.html = string;
            this.update();
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.update();
    }

    public void setHTMLColor(Color color) {
        this.htmlColor = color;
        this.update();
    }

    private void update() {
        this.htmlLabel.setText(this.html);
        this.htmlLabel.setFont(this.font);
        this.htmlLabel.setForeground(this.htmlColor);
        this.htmlLabel.setSize(this.htmlLabel.getPreferredSize());
        this.htmlView = BasicHTML.createHTMLView(this.htmlLabel, this.html == null ? "" : this.html);
        this.htmlBounds = new Rectangle(this.htmlLabel.getPreferredSize());
        this.setBounds(this.htmlLabel.getBounds());
        this.repaint();
    }

    protected void paint(PPaintContext pPaintContext) {
        super.paint(pPaintContext);
        if (this.htmlLabel.getWidth() == 0 || this.htmlLabel.getHeight() == 0) {
            return;
        }
        Graphics2D graphics2D = pPaintContext.getGraphics();
        this.htmlView.paint(graphics2D, this.htmlBounds);
    }
}

