/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp;

import edu.colorado.phet.common.phetcommon.view.AdvancedPanel;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.theramp.ObjectComboBox;
import edu.colorado.phet.theramp.RampControlPanel;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.RampPlotSet;
import edu.colorado.phet.theramp.ShowZeroPointPotentialControl;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.Block;
import edu.colorado.phet.theramp.model.RampObject;
import edu.colorado.phet.theramp.view.FreeBodyDiagram;
import edu.colorado.phet.theramp.view.InitialConditionPanel;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.colorado.phet.theramp.view.arrows.AbstractArrowSet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AdvancedRampControlPanel
extends RampControlPanel {
    private RampModule module;
    private ModelSlider massSlider;

    public AdvancedRampControlPanel(final RampModule rampModule) {
        super(rampModule);
        this.module = rampModule;
        final JCheckBox jCheckBox = new JCheckBox(TheRampStrings.getString("controls.measuring-tape"));
        this.addControl(jCheckBox);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampModule.getRampPanel().setMeasureTapeVisible(jCheckBox.isSelected());
            }
        });
        ShowZeroPointPotentialControl showZeroPointPotentialControl = new ShowZeroPointPotentialControl(rampModule);
        this.addControl(showZeroPointPotentialControl.getComponent());
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        final RampPanel rampPanel = rampModule.getRampPanel();
        final JCheckBox jCheckBox2 = new JCheckBox(TheRampStrings.getString("coordinates.entire-vectors"), rampPanel.isCartesianVisible());
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampPanel.setCartesianArrowsVisible(jCheckBox2.isSelected());
            }
        });
        final JCheckBox jCheckBox3 = new JCheckBox(TheRampStrings.getString("coordinates.parallel-components"), rampPanel.isParallelVisible());
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampPanel.setParallelArrowsVisible(jCheckBox3.isSelected());
            }
        });
        final JCheckBox jCheckBox4 = new JCheckBox(TheRampStrings.getString("coordinates.perpendicular-components"), rampPanel.isPerpendicularVisible());
        jCheckBox4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampPanel.setPerpendicularArrowsVisible(jCheckBox4.isSelected());
            }
        });
        final JCheckBox jCheckBox5 = new JCheckBox(TheRampStrings.getString("coordinates.x-components"), rampPanel.isXVisible());
        jCheckBox5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampPanel.setXArrowsVisible(jCheckBox5.isSelected());
            }
        });
        final JCheckBox jCheckBox6 = new JCheckBox(TheRampStrings.getString("coordinates.y-components"), rampPanel.isYVisible());
        jCheckBox6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampPanel.setYArrowsVisible(jCheckBox6.isSelected());
            }
        });
        verticalLayoutPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), TheRampStrings.getString("coordinates.frames")));
        ((Container)verticalLayoutPanel).add(jCheckBox2);
        ((Container)verticalLayoutPanel).add(jCheckBox3);
        ((Container)verticalLayoutPanel).add(jCheckBox4);
        ((Container)verticalLayoutPanel).add(jCheckBox5);
        ((Container)verticalLayoutPanel).add(jCheckBox6);
        VerticalLayoutPanel verticalLayoutPanel2 = new VerticalLayoutPanel();
        verticalLayoutPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), TheRampStrings.getString("controls.forces-to-show")));
        final JCheckBox jCheckBox7 = new JCheckBox(AbstractArrowSet.FRICTION, true);
        jCheckBox7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampPanel.setForceVisible(jCheckBox7.getText(), jCheckBox7.isSelected());
            }
        });
        final JCheckBox jCheckBox8 = new JCheckBox(AbstractArrowSet.APPLIED, true);
        jCheckBox8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampPanel.setForceVisible(jCheckBox8.getText(), jCheckBox8.isSelected());
            }
        });
        final JCheckBox jCheckBox9 = new JCheckBox(AbstractArrowSet.TOTAL, true);
        jCheckBox9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampPanel.setForceVisible(jCheckBox9.getText(), jCheckBox9.isSelected());
            }
        });
        final JCheckBox jCheckBox10 = new JCheckBox(AbstractArrowSet.WALL, true);
        jCheckBox10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampPanel.setForceVisible(jCheckBox10.getText(), jCheckBox10.isSelected());
            }
        });
        final JCheckBox jCheckBox11 = new JCheckBox(AbstractArrowSet.WEIGHT, true);
        jCheckBox11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampPanel.setForceVisible(jCheckBox11.getText(), jCheckBox11.isSelected());
            }
        });
        final JCheckBox jCheckBox12 = new JCheckBox(AbstractArrowSet.NORMAL, true);
        jCheckBox12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampPanel.setForceVisible(jCheckBox12.getText(), jCheckBox12.isSelected());
            }
        });
        ((Container)verticalLayoutPanel2).add(jCheckBox7);
        ((Container)verticalLayoutPanel2).add(jCheckBox8);
        ((Container)verticalLayoutPanel2).add(jCheckBox9);
        ((Container)verticalLayoutPanel2).add(jCheckBox10);
        ((Container)verticalLayoutPanel2).add(jCheckBox11);
        ((Container)verticalLayoutPanel2).add(jCheckBox12);
        AdvancedPanel advancedPanel = new AdvancedPanel();
        advancedPanel.addControlFullWidth(verticalLayoutPanel);
        advancedPanel.addControlFullWidth(verticalLayoutPanel2);
        this.addControlFullWidth(advancedPanel);
        ObjectComboBox objectComboBox = new ObjectComboBox(rampModule.getRampObjects(), this);
        JLabel jLabel = new JLabel(TheRampStrings.getString("controls.choose-object"));
        this.addControlFullWidth(jLabel);
        this.addControl(objectComboBox);
        this.addControl(super.getFrictionSlider());
        this.addControl(this.getFrictionlessCheckBox());
        this.massSlider = this.createMassSlider();
        this.addControl(this.massSlider);
        super.addPositionAngleControls();
        GraphButtonSet graphButtonSet = new GraphButtonSet();
        this.addAdvancedControl(graphButtonSet, TheRampStrings.getString("display.graphs"));
        InitialConditionPanel initialConditionPanel = new InitialConditionPanel(rampModule);
        this.addAdvancedControl(initialConditionPanel, TheRampStrings.getString("controls.controls"));
        PhetPCanvas phetPCanvas = new PhetPCanvas();
        phetPCanvas.setPreferredSize(new Dimension(200, 200));
        FreeBodyDiagram freeBodyDiagram = new FreeBodyDiagram(rampPanel, rampModule, phetPCanvas);
        phetPCanvas.addWorldChild(freeBodyDiagram);
        AdvancedPanel advancedPanel2 = new AdvancedPanel(TheRampStrings.getString("controls.show-free-body-diagram"), TheRampStrings.getString("controls.hide-free-body-diagram"));
        advancedPanel2.addControlFullWidth(phetPCanvas);
        this.addControlFullWidth(advancedPanel2);
        this.finishInit();
    }

    private void addAdvancedControl(JPanel jPanel, String string) {
        AdvancedPanel advancedPanel = new AdvancedPanel(string + ">>", string + "<<");
        advancedPanel.addControlFullWidth(jPanel);
        this.addControlFullWidth(advancedPanel);
    }

    private ModelSlider createMassSlider() {
        final ModelSlider modelSlider = new ModelSlider(TheRampStrings.getString("property.mass"), TheRampStrings.getString("units.abbr.kg"), 100.0, 500.0, 100.0, new DecimalFormat("000"));
        modelSlider.setModelTicks(new double[]{100.0, 500.0});
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = modelSlider.getValue();
                AdvancedRampControlPanel.this.module.setMass(d);
            }
        });
        this.module.getRampPhysicalModel().getBlock().addListener(new Block.Adapter(){

            public void massChanged() {
                modelSlider.setValue(AdvancedRampControlPanel.this.module.getBlock().getMass());
            }
        });
        return modelSlider;
    }

    public void setup(RampObject rampObject) {
        this.module.setObject(rampObject);
    }

    class GraphButtonSet
    extends VerticalLayoutPanel {
        public GraphButtonSet() {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), TheRampStrings.getString("display.graphs")));
            for (int i = 0; i < AdvancedRampControlPanel.this.module.getRampPlotSet().numDataUnits(); ++i) {
                RampPlotSet.DataUnit dataUnit = AdvancedRampControlPanel.this.module.getRampPlotSet().dataUnitAt(i);
                JCheckBox jCheckBox = new JCheckBox(dataUnit.getFullName(), true);
                jCheckBox.setBackground(dataUnit.getColor());
                jCheckBox.setForeground(Color.black);
                jCheckBox.setFont(new Font("Lucida Sans", 1, 14));
                super.addFullWidth(jCheckBox);
                jCheckBox.addActionListener(new ActionListener(this, dataUnit, jCheckBox){
                    private final /* synthetic */ RampPlotSet.DataUnit val$unit;
                    private final /* synthetic */ JCheckBox val$checkBox;
                    private final /* synthetic */ GraphButtonSet this$1;
                    {
                        this.this$1 = graphButtonSet;
                        this.val$unit = dataUnit;
                        this.val$checkBox = jCheckBox;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$unit.setVisible(this.val$checkBox.isSelected());
                    }
                });
            }
        }
    }
}

