/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.RampObject;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ObjectSelectionPanel
extends JPanel {
    private Font selectedFont = new Font("Lucida Sans", 1, 14);
    private Font normalFont = new Font("Lucida Sans", 0, 12);

    public ObjectSelectionPanel(final RampModule rampModule, RampObject[] rampObjectArray) {
        this.setLayout(new BoxLayout(this, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton[] jRadioButtonArray = new JRadioButton[rampObjectArray.length];
        int n = 0;
        while (n < rampObjectArray.length) {
            JRadioButton jRadioButton;
            final RampObject rampObject = rampObjectArray[n];
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageLoader.loadBufferedImage(rampObjectArray[n].getLocation());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            bufferedImage = BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage, 35);
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            jRadioButtonArray[n] = jRadioButton = new JRadioButton(this.getIconText(rampObject), imageIcon);
            if (n == 0) {
                jRadioButton.setSelected(true);
                jRadioButton.setFont(this.selectedFont);
            } else {
                jRadioButton.setFont(this.normalFont);
            }
            buttonGroup.add(jRadioButton);
            final int n2 = n++;
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    rampModule.setObject(rampObject);
                    for (int i = 0; i < jRadioButtonArray.length; ++i) {
                        JRadioButton jRadioButton = jRadioButtonArray[i];
                        if (i == n2) {
                            jRadioButton.setFont(ObjectSelectionPanel.this.selectedFont);
                            continue;
                        }
                        jRadioButton.setFont(ObjectSelectionPanel.this.normalFont);
                    }
                }
            });
            this.add(jRadioButton);
        }
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), TheRampStrings.getString("controls.choose-object")));
    }

    private String getIconText(RampObject rampObject) {
        char c = '\u03bc';
        return MessageFormat.format(TheRampStrings.getString("readout.object-mass"), rampObject.getName(), new Double(rampObject.getMass()), new Character(c), new Double(rampObject.getStaticFriction()));
    }
}

