/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp;

import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.Block;
import edu.colorado.phet.theramp.model.Ramp;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PositionController {
    private RampModule rampModule;
    private ModelSlider modelSlider;

    public PositionController(RampModule rampModule) {
        this.rampModule = rampModule;
        this.modelSlider = new ModelSlider(TheRampStrings.getString("property.position"), TheRampStrings.getString("units.meters.abbreviation"), -this.getGroundLength(), rampModule.getRampPhysicalModel().getRamp().getLength(), this.getBlockPosition());
        rampModule.getRampPhysicalModel().getBlock().addListener(new Block.Adapter(){

            public void positionChanged() {
                PositionController.this.modelSlider.setValue(PositionController.this.getBlockPosition());
            }
        });
        this.modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PositionController.this.setBlockPosition();
            }
        });
        this.modelSlider.setModelTicks(new double[]{-this.getGroundLength(), 0.0, rampModule.getRampPhysicalModel().getRamp().getLength()});
    }

    private double getGroundLength() {
        return this.rampModule.getRampPhysicalModel().getGround().getLength();
    }

    private void setBlockPosition() {
        if (this.modelSlider.getValue() >= 0.0) {
            this.rampModule.getBlock().setSurface(this.rampModule.getRampPhysicalModel().getRamp());
            this.rampModule.getBlock().setPositionInSurface(this.modelSlider.getValue());
        } else {
            double d = this.getGroundLength() + this.modelSlider.getValue();
            this.rampModule.getBlock().setSurface(this.rampModule.getRampPhysicalModel().getGround());
            this.rampModule.getBlock().setPositionInSurface(d);
        }
    }

    private double getBlockPosition() {
        double d = this.rampModule.getRampPhysicalModel().getBlock().getPositionInSurface();
        if (this.rampModule.getBlock().getSurface() instanceof Ramp) {
            return d;
        }
        return d - this.getGroundLength();
    }

    public JComponent getComponent() {
        return this.modelSlider;
    }
}

