/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.theramp.AudioEnabledController;
import edu.colorado.phet.theramp.PositionController;
import edu.colorado.phet.theramp.RampAngleController;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.Block;
import edu.colorado.phet.theramp.view.GoPauseClearPanel;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RampControlPanel
extends ControlPanel {
    private RampModule rampModule;
    private ModelSlider frictionSlider;
    private RampAngleController rampAngleSlider;
    private PositionController positionSlider;
    private GoPauseClearPanel goPauseClear;
    private JCheckBox frictionlessCheckbox;

    public RampControlPanel(RampModule rampModule) {
        super(rampModule);
        this.rampModule = rampModule;
        JButton jButton = new JButton(TheRampStrings.getString("controls.reset"));
        jButton.setFont(new Font("Lucida Sans", 1, 18));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RampControlPanel.this.getModule().reset();
            }
        });
        this.addControl(jButton);
        JButton jButton2 = new JButton(TheRampStrings.getString("controls.cool-ramp"));
        this.addControl(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RampControlPanel.this.getModule().clearHeat();
            }
        });
        double[] dArray = new double[]{0.0, 0.5, 1.0, 1.5};
        this.frictionSlider = this.createFrictionSlider(dArray, rampModule);
        this.rampAngleSlider = new RampAngleController(rampModule);
        this.positionSlider = new PositionController(rampModule);
        this.goPauseClear = new GoPauseClearPanel(rampModule.getTimeSeriesModel());
        this.frictionlessCheckbox = this.createFrictionlessCheckbox();
    }

    private RampModule getModule() {
        return this.rampModule;
    }

    private void setFrictionEnabled(boolean bl) {
        if (bl) {
            this.setFriction(this.frictionSlider.getValue());
        } else {
            this.setFriction(0.0);
        }
    }

    protected ModelSlider createFrictionSlider(double[] dArray, final RampModule rampModule) {
        final ModelSlider modelSlider = new ModelSlider(TheRampStrings.getString("property.coefficient-of-friction"), "", 0.1, 1.5, 0.5);
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                RampControlPanel.this.setFriction(modelSlider.getValue());
            }
        });
        rampModule.getRampPhysicalModel().getBlock().addListener(new Block.Adapter(){

            public void staticFrictionChanged() {
                modelSlider.setValue(rampModule.getRampPhysicalModel().getBlock().getStaticFriction());
            }

            public void kineticFrictionChanged() {
                modelSlider.setValue(rampModule.getRampPhysicalModel().getBlock().getStaticFriction());
            }
        });
        modelSlider.setModelTicks(dArray);
        this.frictionSlider = modelSlider;
        return modelSlider;
    }

    protected void setFriction(double d) {
        this.getModule().getRampPhysicalModel().getBlock().setStaticFriction(d);
        this.getModule().getRampPhysicalModel().getBlock().setKineticFriction(d);
    }

    private JCheckBox createFrictionlessCheckbox() {
        final JCheckBox jCheckBox = new JCheckBox(TheRampStrings.getString("controls.frictionless"), false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RampControlPanel.this.setFrictionEnabled(!jCheckBox.isSelected());
                RampControlPanel.this.getModule().record();
            }
        });
        this.getModule().addListener(new RampModule.Listener(){

            public void objectChanged() {
                RampControlPanel.this.setFrictionEnabled(!jCheckBox.isSelected());
            }
        });
        return jCheckBox;
    }

    public ModelSlider getFrictionSlider() {
        return this.frictionSlider;
    }

    public void addPositionAngleControls() {
        this.addControlFullWidth(this.positionSlider.getComponent());
        this.addControlFullWidth(this.rampAngleSlider.getComponent());
        this.addControl(this.goPauseClear);
    }

    protected void finishInit() {
        AudioEnabledController audioEnabledController = new AudioEnabledController(this.rampModule);
        this.addControl(audioEnabledController.getCheckBox());
    }

    public JCheckBox getFrictionlessCheckBox() {
        return this.frictionlessCheckbox;
    }

    public void reset() {
        this.frictionlessCheckbox.setSelected(false);
    }
}

