/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.theramp.AdvancedRampControlPanel;
import edu.colorado.phet.theramp.CollisionHandler;
import edu.colorado.phet.theramp.RampControlPanel;
import edu.colorado.phet.theramp.RampPlotSet;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.Block;
import edu.colorado.phet.theramp.model.RampModel;
import edu.colorado.phet.theramp.model.RampObject;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.timeseries_ramp.TimeSeriesModel;
import edu.colorado.phet.theramp.timeseries_ramp.TimeSeriesPlaybackPanel;
import edu.colorado.phet.theramp.view.FireDog;
import edu.colorado.phet.theramp.view.RampPanel;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class RampModule
extends PiccoloModule {
    private RampPanel rampPanel;
    private RampModel rampModel;
    private RampControlPanel rampControlPanel;
    private RampObject[] rampObjects;
    private TimeSeriesPlaybackPanel rampMediaPanel;
    private ArrayList listeners = new ArrayList();
    private PhetFrame phetFrame;
    private boolean firedogInProgress = false;

    public RampModule(PhetFrame phetFrame, IClock iClock) {
        this(TheRampStrings.getString("module.more-features"), phetFrame, iClock);
    }

    public RampModule(String string, PhetFrame phetFrame, IClock iClock) {
        super(string, iClock);
        this.phetFrame = phetFrame;
        this.setModel(new BaseModel());
        this.rampModel = new RampModel(this, iClock);
        this.rampObjects = new RampObject[]{new RampObject("the-ramp/images/cabinet.gif", TheRampStrings.getString("object.file-cabinet"), 0.8, 100.0, 0.3, 0.3, 0.4), new RampObject("the-ramp/images/fridge.gif", TheRampStrings.getString("object.refrigerator"), 0.35, 175.0, 0.5, 0.5, 0.4), new RampObject("the-ramp/images/piano.png", TheRampStrings.getString("object.piano"), 0.8, 225.0, 0.4, 0.4, 0.6, 20.0), new RampObject("the-ramp/images/crate.gif", TheRampStrings.getString("object.crate"), 0.8, 300.0, 0.7, 0.7, 0.3), new RampObject("the-ramp/images/ollie.gif", TheRampStrings.getString("object.dog"), 0.8, 15.0, 0.1, 0.1, 0.3, 5.0)};
        this.rampPanel = this.createRampPanel();
        super.setPhetPCanvas(this.rampPanel);
        this.rampControlPanel = this.createRampControlPanel();
        this.setControlPanel(this.rampControlPanel);
        this.setObject(this.rampObjects[0]);
        this.rampMediaPanel = new TimeSeriesPlaybackPanel(this.getRampTimeSeriesModel());
        iClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                RampModule.this.getRampPhysicalModel().setupForces();
                RampModule.this.updateGraphics(clockEvent);
            }
        });
        this.setClockControlPanel(this.rampMediaPanel);
        this.rampModel.getBlock().addListener(new CollisionHandler(this));
        this.doReset();
    }

    protected RampControlPanel createRampControlPanel() {
        return new AdvancedRampControlPanel(this);
    }

    protected RampPanel createRampPanel() {
        return new RampPanel(this);
    }

    private TimeSeriesModel getRampTimeSeriesModel() {
        return this.rampModel.getRampTimeSeriesModel();
    }

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
    }

    public void updateGraphics(ClockEvent clockEvent) {
        super.updateGraphics(clockEvent);
        this.rampPanel.updateGraphics();
    }

    public RampPanel getRampPanel() {
        return this.rampPanel;
    }

    public RampPhysicalModel getRampPhysicalModel() {
        return this.getRampModel().getRampPhysicalModel();
    }

    private RampModel getRampModel() {
        return this.rampModel;
    }

    public void reset() {
        if (this.resetDialogOk()) {
            this.doReset();
        }
    }

    public boolean resetDialogOk() {
        JOptionPane jOptionPane = new JOptionPane(TheRampStrings.getString("confirm-reset"), 3, 2);
        JDialog jDialog = jOptionPane.createDialog(this.rampPanel, TheRampStrings.getString("confirm.reset.title"));
        jOptionPane.selectInitialValue();
        Point point = this.getPhetPCanvas().getLocationOnScreen();
        Rectangle2D rectangle2D = this.getRampPanel().getClearButtonCanvasRect();
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getY());
        jDialog.setLocation((int)((double)point.x + double_.x), (int)((double)point.y + double_.y - (double)(jDialog.getHeight() / 2)));
        jDialog.show();
        jDialog.dispose();
        return jOptionPane.getValue().equals(new Integer(0));
    }

    public void doReset() {
        this.rampModel.reset();
        this.rampPanel.reset();
        this.rampControlPanel.reset();
        this.setObject(this.rampObjects[0]);
        this.updateReadouts();
    }

    public void setObject(RampObject rampObject) {
        this.rampModel.setObject(rampObject);
        this.getRampPanel().setObject(rampObject);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.objectChanged();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public Block getBlock() {
        return this.getRampModel().getBlock();
    }

    public void clearHeat() {
        this.cueFirefighter();
    }

    public void clearHeatSansFiredog() {
        this.getRampPhysicalModel().clearHeat();
    }

    public void cueFirefighter() {
        if (!this.firedogInProgress) {
            this.firedogInProgress = true;
            new FireDog(this).putOutFire();
        }
    }

    public void setAppliedForce(double d) {
        this.getRampModel().setAppliedForce(d);
    }

    public double getRampAngle() {
        return this.getRampPhysicalModel().getRampAngle();
    }

    public void setRampAngle(double d) {
        this.getRampPhysicalModel().setRampAngle(d);
    }

    public double getGlobalMinPosition() {
        return this.getRampPhysicalModel().getGlobalMinPosition();
    }

    public double getGlobalMaxPosition() {
        return this.getRampPhysicalModel().getGlobalMaxPosition();
    }

    public double getGlobalBlockPosition() {
        return this.getRampPhysicalModel().getGlobalBlockPosition();
    }

    public void setGlobalBlockPosition(double d) {
        this.getRampPhysicalModel().setGlobalBlockPosition(d);
    }

    public int numMaximizedBarGraphs() {
        return this.rampPanel.numMaximizedBarGraphs();
    }

    public void updateReadouts() {
        this.rampPanel.updateReadouts();
    }

    public void firedogFinished() {
        this.firedogInProgress = false;
    }

    public RampObject[] getRampObjects() {
        return this.rampObjects;
    }

    public void record() {
        this.rampModel.record();
    }

    public void repaintBackground() {
        this.rampPanel.repaintBackground();
    }

    public void updateModel(double d) {
        this.getRampPhysicalModel().stepInTime(d);
    }

    public void updatePlots(RampPhysicalModel rampPhysicalModel, double d) {
        this.getRampPlotSet().updatePlots(rampPhysicalModel, d);
    }

    public TimeSeriesModel getTimeSeriesModel() {
        return this.getRampModel().getRampTimeSeriesModel();
    }

    public void setMass(double d) {
        this.getRampModel().setMass(d);
    }

    public RampPlotSet getRampPlotSet() {
        return this.rampPanel.getRampPlotSet();
    }

    public static interface Listener {
        public void objectChanged();
    }
}

