/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.SimpleRampModule;
import edu.colorado.phet.theramp.TheRampStrings;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class TheRampApplication
extends PhetApplication {
    private static final String VERSION = PhetApplicationConfig.getVersion("the-ramp").formatForTitleBar();
    private RampModule simpleRampModule = new SimpleRampModule(this.getPhetFrame(), this.createClock());
    private RampModule advancedFeatureModule = new RampModule(this.getPhetFrame(), this.createClock());

    public TheRampApplication(String[] stringArray, FrameSetup frameSetup) {
        super(stringArray, TheRampStrings.getString("the.ramp"), TheRampStrings.getString("the.ramp.simulation"), VERSION, frameSetup);
        this.setModules(new Module[]{this.simpleRampModule, this.advancedFeatureModule});
    }

    private IClock createClock() {
        return new SwingClock(30, 0.03333333333333333);
    }

    public static void main(String[] stringArray) {
        TheRampStrings.init(stringArray);
        PhetLookAndFeel phetLookAndFeel = new PhetLookAndFeel();
        phetLookAndFeel.apply();
        PhetLookAndFeel.setLookAndFeel();
        FrameSetup.MaxExtent maxExtent = new FrameSetup.MaxExtent(new FrameSetup.CenteredWithSize(800, 600));
        final TheRampApplication theRampApplication = new TheRampApplication(stringArray, maxExtent);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    theRampApplication.startApplication();
                    new FrameSetup.MaxExtent().initialize(theRampApplication.getPhetFrame());
                    theRampApplication.simpleRampModule.getPhetPCanvas().requestFocus();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

