/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.common;

import edu.colorado.phet.common.phetcommon.math.ModelViewTransform1D;
import edu.colorado.phet.theramp.common.VerticalTextGraphic;
import edu.colorado.phet.theramp.view.RampFontSet;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;

public class BarGraphic2D
extends PNode {
    private ModelViewTransform1D transform1D;
    private double value;
    private int x;
    private int width;
    private int y;
    private VerticalTextGraphic label;
    private PPath rectangle3DGraphic;
    public double labelHeight;
    private double labelWidth;

    public BarGraphic2D(String string, ModelViewTransform1D modelViewTransform1D, double d, int n, int n2, int n3, int n4, int n5, Paint paint) {
        this.transform1D = modelViewTransform1D;
        this.value = d;
        this.x = n;
        this.y = n3;
        this.width = n2;
        this.rectangle3DGraphic = new PPath(null);
        this.rectangle3DGraphic.setPaint(paint);
        this.rectangle3DGraphic.setStroke(new BasicStroke(1.0f));
        this.rectangle3DGraphic.setStrokePaint(Color.black);
        Color color = new Color(240, 225, 255);
        this.label = new VerticalTextGraphic(RampFontSet.getFontSet().getBarFont(), string, Color.black, color);
        this.addChild(this.rectangle3DGraphic);
        this.addChild(this.label);
        this.labelHeight = this.label.getHeight();
        this.labelWidth = this.label.getWidth();
        this.updateBar();
    }

    private void updateBar() {
        int n = this.computeHeight();
        Rectangle rectangle = new Rectangle(this.x, this.y - n, this.width, n);
        this.label.setOffset((double)(rectangle.x + 2) - this.labelWidth, (int)((double)(5 + this.y) + this.labelHeight));
        this.rectangle3DGraphic.setPathTo(rectangle);
    }

    public void setValue(double d) {
        if (d != this.value && Math.abs(d) != Math.abs(this.value)) {
            this.value = d;
            if (d < 0.0) {
                this.rectangle3DGraphic.setOffset(0.0, -this.computeHeight());
            } else {
                this.rectangle3DGraphic.setOffset(0.0, 0.0);
            }
            this.value = Math.abs(d);
            this.updateBar();
        }
    }

    private int computeHeight() {
        return this.transform1D.modelToView(this.value);
    }

    public void setBarHeight(double d) {
        this.y = (int)d;
        this.updateBar();
    }
}

