/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.common;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.BoundGraphic;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.DecimalFormat;

public class MeasuringTape
extends PNode {
    private ModelViewTransform2D modelViewTransform2D;
    private Point2D.Double modelSrc;
    private Point2D.Double modelDst;
    private BodyGraphic bodyGraphic;
    private TapeGraphic tapeGraphic;
    private EndGraphic endGraphic;
    private ReadoutGraphic readoutGraphic;

    public MeasuringTape(Component component, ModelViewTransform2D modelViewTransform2D, Point2D.Double double_) {
        this.modelViewTransform2D = modelViewTransform2D;
        this.modelSrc = double_;
        this.modelDst = new Point2D.Double(double_.x + modelViewTransform2D.viewToModelDifferentialX(100.0), double_.y);
        this.bodyGraphic = new BodyGraphic();
        this.tapeGraphic = new TapeGraphic();
        this.endGraphic = new EndGraphic();
        this.readoutGraphic = new ReadoutGraphic(TheRampStrings.getString("units.abbr.meters"));
        this.addChild(this.tapeGraphic);
        this.addChild(this.bodyGraphic);
        this.addChild(this.endGraphic);
        this.addChild(this.readoutGraphic);
        this.update();
    }

    private Dimension2D getDelta(PInputEvent pInputEvent) {
        PDimension pDimension = pInputEvent.getDeltaRelativeTo(this);
        return pDimension;
    }

    private void translateAll(double d, double d2) {
        Point2D point2D = this.modelViewTransform2D.viewToModelDifferential(new Point2D.Double(d, d2));
        this.modelSrc.x += point2D.getX();
        this.modelSrc.y += point2D.getY();
        this.modelDst.x += point2D.getX();
        this.modelDst.y += point2D.getY();
        this.update();
    }

    private void update() {
        Point point = this.modelViewTransform2D.modelToView(this.modelSrc);
        Point point2 = this.modelViewTransform2D.modelToView(this.modelDst);
        Vector2D.Double double_ = new Vector2D.Double(point, point2);
        Line2D.Double double_2 = new Line2D.Double(point, point2);
        this.tapeGraphic.setLine(double_2);
        this.bodyGraphic.setTransform(new AffineTransform());
        Point2D.Double double_3 = new Point2D.Double(point.getX() - this.bodyGraphic.getImageGraphic().getWidth(), point.getY() - this.bodyGraphic.getImageGraphic().getHeight());
        this.bodyGraphic.translate(((Point2D)double_3).getX(), ((Point2D)double_3).getY());
        this.bodyGraphic.rotateAboutPoint(double_.getAngle(), this.bodyGraphic.getImageGraphic().getWidth(), this.bodyGraphic.getImageGraphic().getHeight());
        this.endGraphic.setOffset(point2.getX() - this.endGraphic.getShapeGraphic().getWidth() / 2.0, point2.getY() - this.endGraphic.getShapeGraphic().getHeight() / 2.0);
        double d = new Vector2D.Double(this.modelSrc, this.modelDst).getMagnitude();
        this.readoutGraphic.setDistance(d);
        this.readoutGraphic.setOffset(point.x, (int)((double)point.y + this.readoutGraphic.getHeight() * 1.2 + 7.0));
    }

    private void translateEndPoint(double d, double d2) {
        Point2D point2D = this.modelViewTransform2D.viewToModelDifferential(new Point2D.Double(d, d2));
        this.modelDst.x += point2D.getX();
        this.modelDst.y += point2D.getY();
        System.out.println("modelDst = " + this.modelDst);
        this.update();
    }

    private Component getComponent() {
        return null;
    }

    static /* synthetic */ Dimension2D access$100(MeasuringTape measuringTape, PInputEvent pInputEvent) {
        return measuringTape.getDelta(pInputEvent);
    }

    static /* synthetic */ void access$200(MeasuringTape measuringTape, double d, double d2) {
        measuringTape.translateAll(d, d2);
    }

    static /* synthetic */ void access$500(MeasuringTape measuringTape, double d, double d2) {
        measuringTape.translateEndPoint(d, d2);
    }

    static class CrossHairGraphic
    extends PNode {
        private int length;

        public CrossHairGraphic(Component component, int n) {
            this.length = n;
            PPath pPath = new PPath(new Line2D.Double(n / 2, 0.0, n / 2, n));
            pPath.setStroke(new BasicStroke(2.0f));
            pPath.setStrokePaint(Color.red);
            PPath pPath2 = new PPath(new Line2D.Double(0.0, n / 2, n, n / 2));
            pPath2.setStroke(new BasicStroke(2.0f));
            pPath2.setStrokePaint(Color.red);
            this.addChild(pPath);
            this.addChild(pPath2);
            this.setPickable(false);
            this.setChildrenPickable(false);
        }
    }

    class ReadoutGraphic
    extends PNode {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        private String units;
        public PText phetShadowTextGraphic;

        public ReadoutGraphic(String string) {
            this.units = string;
            this.phetShadowTextGraphic = new PText("");
            this.phetShadowTextGraphic.setFont(new Font("Lucida Sans", 1, 14));
            this.phetShadowTextGraphic.setTextPaint(Color.black);
            BoundGraphic boundGraphic = new BoundGraphic(this.phetShadowTextGraphic, 2.0, 2.0);
            boundGraphic.setStroke(new BasicStroke());
            boundGraphic.setStrokePaint(Color.black);
            boundGraphic.setPaint(Color.green);
            this.addChild(boundGraphic);
            this.addChild(this.phetShadowTextGraphic);
        }

        public void setDistance(double d) {
            String string = this.decimalFormat.format(d) + " " + this.units;
            this.phetShadowTextGraphic.setText(string);
        }
    }

    class EndGraphic
    extends PNode {
        private PPath phetShapeGraphic;

        public EndGraphic() {
            Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, 15.0, 15.0);
            this.phetShapeGraphic = new PPath(double_);
            this.phetShapeGraphic.setPaint(Color.black);
            this.addChild(this.phetShapeGraphic);
            this.addInputEventListener(new PBasicInputEventHandler(this, MeasuringTape.this){
                private final /* synthetic */ MeasuringTape val$this$0;
                private final /* synthetic */ EndGraphic this$1;
                {
                    this.this$1 = endGraphic;
                    this.val$this$0 = measuringTape;
                }

                public void mouseDragged(PInputEvent pInputEvent) {
                    Dimension2D dimension2D = MeasuringTape.access$100(EndGraphic.access$400(this.this$1), pInputEvent);
                    MeasuringTape.access$500(EndGraphic.access$400(this.this$1), dimension2D.getWidth(), dimension2D.getHeight());
                }
            });
            this.addInputEventListener(new CursorHandler(12));
            int n = 10;
            CrossHairGraphic crossHairGraphic = new CrossHairGraphic(MeasuringTape.this.getComponent(), n);
            crossHairGraphic.setPaint(Color.yellow);
            this.addChild(crossHairGraphic);
            crossHairGraphic.setOffset(this.phetShapeGraphic.getWidth() / 2.0 - (double)(n / 2), this.phetShapeGraphic.getHeight() / 2.0 - (double)(n / 2));
        }

        public PPath getShapeGraphic() {
            return this.phetShapeGraphic;
        }

        static /* synthetic */ MeasuringTape access$400(EndGraphic endGraphic) {
            return endGraphic.MeasuringTape.this;
        }
    }

    class TapeGraphic
    extends PNode {
        public PPath phetShapeGraphic = new PPath(null);

        public TapeGraphic() {
            this.phetShapeGraphic.setStroke(new BasicStroke(2.0f));
            this.phetShapeGraphic.setPaint(Color.black);
            this.addChild(this.phetShapeGraphic);
        }

        public void setLine(Line2D.Double double_) {
            this.phetShapeGraphic.setPathTo(double_);
        }
    }

    class BodyGraphic
    extends PNode {
        private PImage imageGraphic;

        public BodyGraphic() {
            try {
                this.imageGraphic = new PImage(ImageLoader.loadBufferedImage("the-ramp/images/tape.gif"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.addChild(this.imageGraphic);
            this.addInputEventListener(new PBasicInputEventHandler(this){
                private final /* synthetic */ BodyGraphic this$1;
                {
                    this.this$1 = bodyGraphic;
                }

                public void mouseDragged(PInputEvent pInputEvent) {
                    Dimension2D dimension2D = MeasuringTape.access$100(BodyGraphic.access$000(this.this$1), pInputEvent);
                    MeasuringTape.access$200(BodyGraphic.access$000(this.this$1), dimension2D.getWidth(), dimension2D.getHeight());
                }
            });
            int n = 10;
            CrossHairGraphic crossHairGraphic = new CrossHairGraphic(MeasuringTape.this.getComponent(), n);
            this.addChild(crossHairGraphic);
            crossHairGraphic.setOffset(this.imageGraphic.getWidth() - (double)(n / 2), this.imageGraphic.getHeight() - (double)(n / 2));
            this.addInputEventListener(new CursorHandler(12));
        }

        public PImage getImageGraphic() {
            return this.imageGraphic;
        }

        static /* synthetic */ MeasuringTape access$000(BodyGraphic bodyGraphic) {
            return bodyGraphic.MeasuringTape.this;
        }
    }
}

