/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.common;

import edu.colorado.phet.theramp.common.PhetAudioException;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;

public class PhetAudioClip {
    private URL url;
    private Clip line;

    public PhetAudioClip(String string) {
        this(PhetAudioClip.toURL(string));
    }

    private static URL toURL(String string) {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL == null) {
            throw new RuntimeException("Null URL for resource name: " + string);
        }
        return uRL;
    }

    public PhetAudioClip(URL uRL) throws PhetAudioException {
        this.url = uRL;
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = AudioSystem.getAudioFileFormat(uRL);
            AudioFormat audioFormat = audioFileFormat.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
            this.line = (Clip)AudioSystem.getLine(info);
            this.line.open(AudioSystem.getAudioInputStream(uRL.openStream()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PhetAudioException(exception, this);
        }
    }

    public void playAndWait() {
        this.line.setFramePosition(0);
        this.line.start();
    }

    public void play() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                PhetAudioClip.this.playAndWait();
            }
        });
        thread.start();
    }

    public URL getURL() {
        return this.url;
    }
}

