/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.model;

import edu.colorado.phet.theramp.model.Block;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.model.Surface;

public class Ground
extends Surface {
    public Ground(double d, double d2, double d3, double d4, double d5) {
        super(d, d2, d3, d4, d5);
    }

    public Surface copyState() {
        return new Ground(this.getAngle(), this.getLength(), this.getOrigin().getX(), this.getOrigin().getY(), this.getDistanceOffset());
    }

    public boolean applyBoundaryConditions(RampPhysicalModel rampPhysicalModel, Block block) {
        if (block.getPositionInSurface() < 0.0) {
            block.setPositionInSurface(0.0);
            block.setVelocity(0.0);
            super.notifyCollision();
            return true;
        }
        if (block.getPositionInSurface() > this.getLength()) {
            block.setSurface(rampPhysicalModel.getRamp());
            double d = block.getPositionInSurface() - this.getLength();
            if (d > rampPhysicalModel.getRamp().getLength()) {
                d = rampPhysicalModel.getRamp().getLength();
            }
            block.setPositionInSurface(d);
        }
        return false;
    }

    public double getWallForce(double d, Block block) {
        if (block.getPositionInSurface() == 0.0 && d < 0.0) {
            return -d;
        }
        return 0.0;
    }
}

