/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.model;

import edu.colorado.phet.theramp.model.Block;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.model.Surface;

public class Ramp
extends Surface {
    public Ramp(double d, double d2) {
        super(d, d2);
    }

    public Ramp(double d, double d2, double d3, double d4, double d5) {
        super(d, d2, d3, d4, d5);
    }

    public Surface copyState() {
        return new Ramp(this.getAngle(), this.getLength(), this.getOrigin().getX(), this.getOrigin().getY(), this.getDistanceOffset());
    }

    public boolean applyBoundaryConditions(RampPhysicalModel rampPhysicalModel, Block block) {
        if (block.getPositionInSurface() < 0.0) {
            block.setSurface(rampPhysicalModel.getGround());
            double d = -block.getPositionInSurface();
            if (d > rampPhysicalModel.getGround().getLength()) {
                d = rampPhysicalModel.getGround().getLength();
            }
            block.setPositionInSurface(rampPhysicalModel.getGround().getLength() - d);
        } else if (block.getPositionInSurface() > this.getLength()) {
            block.setPositionInSurface(this.getLength());
            block.setVelocity(0.0);
            super.notifyCollision();
            return true;
        }
        return false;
    }

    public double getWallForce(double d, Block block) {
        if (block.getPositionInSurface() == this.getLength() && d > 0.0) {
            return -d;
        }
        return 0.0;
    }
}

