/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.model;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.model.Block;
import edu.colorado.phet.theramp.model.RampObject;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.model.RampTimeSeriesModel;
import edu.colorado.phet.theramp.timeseries_ramp.TimeSeriesModel;

public class RampModel {
    private RampPhysicalModel rampPhysicalModel = new RampPhysicalModel();
    private RampTimeSeriesModel rampTimeSeriesModel;

    public RampModel(RampModule rampModule, IClock iClock) {
        this.rampPhysicalModel.reset();
        this.rampTimeSeriesModel = new RampTimeSeriesModel(rampModule);
        iClock.addClockListener(this.rampTimeSeriesModel);
    }

    public TimeSeriesModel getRampTimeSeriesModel() {
        return this.rampTimeSeriesModel;
    }

    public RampPhysicalModel getRampPhysicalModel() {
        return this.rampPhysicalModel;
    }

    public void reset() {
        this.rampTimeSeriesModel.reset();
        this.rampPhysicalModel.reset();
    }

    public void setObject(RampObject rampObject) {
        this.rampPhysicalModel.setObject(rampObject);
    }

    public Block getBlock() {
        return this.rampPhysicalModel.getBlock();
    }

    public void record() {
        this.rampTimeSeriesModel.setRecordMode();
        this.rampTimeSeriesModel.setPaused(false);
    }

    public void setMass(double d) {
        this.rampPhysicalModel.setMass(d);
    }

    public void setAppliedForce(double d) {
        this.rampPhysicalModel.setAppliedForce(d);
    }
}

