/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.timeseries_ramp.ObjectTimePoint;
import edu.colorado.phet.theramp.timeseries_ramp.ObjectTimeSeries;
import edu.colorado.phet.theramp.timeseries_ramp.TimeSeriesModel;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class RampTimeSeriesModel
extends TimeSeriesModel {
    private RampModule rampModule;
    private ObjectTimeSeries series = new ObjectTimeSeries();
    private boolean recordedLastTime = false;

    public RampTimeSeriesModel(RampModule rampModule) {
        super(30.0);
        this.rampModule = rampModule;
    }

    public void repaintBackground() {
        this.rampModule.repaintBackground();
    }

    public void updateModel(ClockEvent clockEvent) {
        this.rampModule.updateModel(clockEvent.getSimulationTimeChange());
        if (this.getRecordTime() <= 30.0 && !this.recordedLastTime) {
            RampPhysicalModel rampPhysicalModel = this.rampModule.getRampPhysicalModel().getState();
            this.series.addPoint(rampPhysicalModel, this.getRecordTime());
            this.rampModule.updatePlots(rampPhysicalModel, this.getRecordTime());
            if (this.getRecordTime() >= 30.0) {
                this.recordedLastTime = true;
            }
        } else {
            this.rampModule.updateReadouts();
        }
    }

    public void setReplayTime(double d) {
        RampPhysicalModel rampPhysicalModel;
        super.setReplayTime(d);
        ObjectTimePoint objectTimePoint = this.series.getValueForTime(d);
        if (objectTimePoint != null && (rampPhysicalModel = (RampPhysicalModel)objectTimePoint.getValue()) != null) {
            this.rampModule.getRampPhysicalModel().setState(rampPhysicalModel);
        }
        this.rampModule.updateReadouts();
    }

    public void reset() {
        super.reset();
        this.series.reset();
        this.rampModule.getRampPlotSet().reset();
        this.recordedLastTime = false;
        this.rampModule.clearHeatSansFiredog();
    }

    protected boolean confirmReset() {
        int n = JOptionPane.showConfirmDialog(this.getSimulationPanel(), TheRampStrings.getString("confirm-clear-graphs"), TheRampStrings.getString("confirm.clear"), 2, 3);
        return n == 0;
    }

    public JComponent getSimulationPanel() {
        return this.rampModule.getSimulationPanel();
    }

    public RampModule getRampModule() {
        return this.rampModule;
    }

    public void clockTicked(ClockEvent clockEvent) {
        super.clockTicked(clockEvent);
        if (this.isPaused()) {
            this.rampModule.updateReadouts();
        }
    }
}

