/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.model;

import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.theramp.model.Block;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class Surface
extends SimpleObservable {
    private double angle;
    private double x0;
    private double y0;
    private double length;
    private double distanceOffset;
    ArrayList collisionListeners = new ArrayList();

    public Surface(double d, double d2) {
        this(d, d2, 0.0, 0.0, 0.0);
    }

    public Surface(double d, double d2, double d3, double d4, double d5) {
        this.angle = d;
        this.x0 = d3;
        this.y0 = d4;
        this.length = d2;
        this.distanceOffset = d5;
    }

    public Point2D getOrigin() {
        return new Point2D.Double(this.x0, this.y0);
    }

    public double getLength() {
        return this.length;
    }

    public Point2D getLocation(double d) {
        AbstractVector2D abstractVector2D = Vector2D.Double.parseAngleAndMagnitude(d, this.angle);
        return abstractVector2D.getDestination(this.getOrigin());
    }

    public Point2D getEndPoint() {
        return this.getLocation(this.length);
    }

    public void setAngle(double d) {
        if (this.angle != d) {
            this.angle = d;
            this.notifyObservers();
        }
    }

    public double getAngle() {
        return this.angle;
    }

    public double getHeight() {
        return this.length * Math.sin(this.angle);
    }

    public abstract Surface copyState();

    public void setState(Surface surface) {
        this.setAngle(surface.angle);
        this.x0 = surface.x0;
        this.y0 = surface.y0;
        this.length = surface.length;
        this.distanceOffset = surface.distanceOffset;
    }

    public abstract boolean applyBoundaryConditions(RampPhysicalModel var1, Block var2);

    public abstract double getWallForce(double var1, Block var3);

    public double getDistanceOffset() {
        return this.distanceOffset;
    }

    public void setDistanceOffset(double d) {
        this.distanceOffset = d;
    }

    public void notifyCollision() {
        for (int i = 0; i < this.collisionListeners.size(); ++i) {
            CollisionListener collisionListener = (CollisionListener)this.collisionListeners.get(i);
            collisionListener.collided(this);
        }
    }

    public void addCollisionListener(CollisionListener collisionListener) {
        this.collisionListeners.add(collisionListener);
    }

    public static interface CollisionListener {
        public void collided(Surface var1);
    }
}

