/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.model;

import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.view.RampLookAndFeel;
import java.awt.Color;
import java.text.MessageFormat;

public abstract class ValueAccessor {
    private String name;
    private String html;
    private String units;
    private String unitAbbreviation;
    private Color color;
    private String fullName;
    public static final String joules = TheRampStrings.getString("units.joules");
    public static final String joulesAbbreviation = TheRampStrings.getString("units.abbr.joules");

    protected ValueAccessor(String string, String string2, String string3, String string4, Color color, String string5) {
        this.name = string;
        this.html = string2;
        this.units = string3;
        this.unitAbbreviation = string4;
        this.color = color;
        this.fullName = string5;
    }

    public abstract double getValue(RampPhysicalModel var1);

    public Color getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getUnitsAbbreviation() {
        return this.unitAbbreviation;
    }

    public String getHTML() {
        return this.html;
    }

    public static class ParallelWallForceAccessor
    extends ParallelForceAccessor {
        public ParallelWallForceAccessor(RampLookAndFeel rampLookAndFeel) {
            super(TheRampStrings.getString("forces.parallel-wall"), rampLookAndFeel.getWallForceColor(), TheRampStrings.getString("forces.Wall").toLowerCase());
        }

        public double getValue(RampPhysicalModel rampPhysicalModel) {
            return rampPhysicalModel.getParallelWallForce();
        }
    }

    public static class ParallelGravityAccessor
    extends ParallelForceAccessor {
        public ParallelGravityAccessor(RampLookAndFeel rampLookAndFeel) {
            super(TheRampStrings.getString("forces.parallel-gravity"), rampLookAndFeel.getWeightColor(), TheRampStrings.getString("forces.Gravity").toLowerCase());
        }

        public double getValue(RampPhysicalModel rampPhysicalModel) {
            return rampPhysicalModel.getParallelWeightForce();
        }
    }

    public static class ParallelAppliedAccessor
    extends ParallelForceAccessor {
        public ParallelAppliedAccessor(RampLookAndFeel rampLookAndFeel) {
            super(TheRampStrings.getString("forces.parallel-applied"), rampLookAndFeel.getAppliedForceColor(), TheRampStrings.getString("forces.applied").toLowerCase());
        }

        public double getValue(RampPhysicalModel rampPhysicalModel) {
            return rampPhysicalModel.getParallelAppliedForce();
        }
    }

    public static class ParallelFrictionAccessor
    extends ParallelForceAccessor {
        public ParallelFrictionAccessor(RampLookAndFeel rampLookAndFeel) {
            super(TheRampStrings.getString("forces.parallel-friction"), rampLookAndFeel.getFrictionForceColor(), TheRampStrings.getString("forces.friction"));
        }

        public double getValue(RampPhysicalModel rampPhysicalModel) {
            return rampPhysicalModel.getParallelFrictionForce();
        }
    }

    public static abstract class ParallelForceAccessor
    extends ValueAccessor {
        protected ParallelForceAccessor(String string, Color color, String string2) {
            super(string, MessageFormat.format(TheRampStrings.getString("force.subscript"), string2), TheRampStrings.getString("units.newtons"), TheRampStrings.getString("units.abbr.newtons"), color, string);
        }
    }

    public static abstract class WorkAccessor
    extends ValueAccessor {
        public WorkAccessor(String string, Color color, String string2) {
            super(string, MessageFormat.format(TheRampStrings.getString("work.subscript"), string2), joules, joulesAbbreviation, color, MessageFormat.format(TheRampStrings.getString("0.work"), string));
        }
    }

    public static abstract class EnergyAccessor
    extends ValueAccessor {
        public EnergyAccessor(String string, Color color) {
            super(string, string, joules, joulesAbbreviation, color, MessageFormat.format(TheRampStrings.getString("0.energy"), string));
        }
    }

    public static class TotalWork
    extends WorkAccessor {
        public TotalWork(RampLookAndFeel rampLookAndFeel) {
            super(TheRampStrings.getString("forces.Net"), rampLookAndFeel.getTotalWorkColor(), TheRampStrings.getString("forces.Net").toLowerCase());
        }

        public double getValue(RampPhysicalModel rampPhysicalModel) {
            return rampPhysicalModel.getTotalWork();
        }
    }

    public static class GravityWork
    extends WorkAccessor {
        public GravityWork(RampLookAndFeel rampLookAndFeel) {
            super(TheRampStrings.getString("forces.Gravity"), rampLookAndFeel.getGravityWorkColor(), TheRampStrings.getString("forces.Gravity").toLowerCase());
        }

        public double getValue(RampPhysicalModel rampPhysicalModel) {
            return rampPhysicalModel.getGravityWork();
        }
    }

    public static class FrictiveWork
    extends WorkAccessor {
        public FrictiveWork(RampLookAndFeel rampLookAndFeel) {
            super(TheRampStrings.getString("controls.friction"), rampLookAndFeel.getFrictionWorkColor(), TheRampStrings.getString("forces.friction"));
        }

        public double getValue(RampPhysicalModel rampPhysicalModel) {
            return rampPhysicalModel.getFrictiveWork();
        }
    }

    public static class AppliedWork
    extends WorkAccessor {
        public AppliedWork(RampLookAndFeel rampLookAndFeel) {
            super(TheRampStrings.getString("forces.applied"), rampLookAndFeel.getAppliedWorkColor(), TheRampStrings.getString("forces.applied").toLowerCase());
        }

        public double getValue(RampPhysicalModel rampPhysicalModel) {
            return rampPhysicalModel.getAppliedWork();
        }
    }

    public static class ThermalEnergy
    extends EnergyAccessor {
        public ThermalEnergy(RampLookAndFeel rampLookAndFeel) {
            super(TheRampStrings.getString("energy.thermal"), rampLookAndFeel.getThermalEnergyColor());
        }

        public double getValue(RampPhysicalModel rampPhysicalModel) {
            return rampPhysicalModel.getThermalEnergy();
        }
    }

    public static class PotentialEnergy
    extends EnergyAccessor {
        public PotentialEnergy(RampLookAndFeel rampLookAndFeel) {
            super(TheRampStrings.getString("energy.potential"), rampLookAndFeel.getPotentialEnergyColor());
        }

        public double getValue(RampPhysicalModel rampPhysicalModel) {
            return rampPhysicalModel.getPotentialEnergy();
        }
    }

    public static class KineticEnergy
    extends EnergyAccessor {
        public KineticEnergy(RampLookAndFeel rampLookAndFeel) {
            super(TheRampStrings.getString("energy.kinetic"), rampLookAndFeel.getKineticEnergyColor());
        }

        public double getValue(RampPhysicalModel rampPhysicalModel) {
            return rampPhysicalModel.getBlock().getKineticEnergy();
        }
    }

    public static class TotalEnergy
    extends EnergyAccessor {
        public TotalEnergy(RampLookAndFeel rampLookAndFeel) {
            super(TheRampStrings.getString("forces.total"), rampLookAndFeel.getTotalEnergyColor());
        }

        public double getValue(RampPhysicalModel rampPhysicalModel) {
            return rampPhysicalModel.getTotalEnergy();
        }
    }
}

