/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.timeseries_ramp;

import edu.colorado.phet.theramp.timeseries_ramp.TimePoint;
import java.util.ArrayList;

public class TimeSeries {
    private ArrayList pts = new ArrayList();
    private ArrayList observers = new ArrayList();

    public void addPoint(double d, double d2) {
        TimePoint timePoint = new TimePoint(d, d2);
        this.pts.add(timePoint);
        this.notifyAdded();
    }

    private void notifyAdded() {
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer observer = (Observer)this.observers.get(i);
            observer.dataAdded();
        }
    }

    public TimePoint getLastPoint() {
        return this.lastPointAt(0);
    }

    public void reset() {
        this.pts = new ArrayList();
        this.notifyCleared();
    }

    private void notifyCleared() {
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer observer = (Observer)this.observers.get(i);
            observer.cleared();
        }
    }

    public TimePoint lastPointAt(int n) {
        return this.pointAt(this.pts.size() - 1 - n);
    }

    public TimePoint pointAt(int n) {
        return (TimePoint)this.pts.get(n);
    }

    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    public int numPoints() {
        return this.pts.size();
    }

    public static interface Observer {
        public void dataAdded();

        public void cleared();
    }
}

