/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.timeseries_ramp;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.theramp.timeseries_ramp.ClockTickListener;
import edu.colorado.phet.theramp.timeseries_ramp.Mode;
import edu.colorado.phet.theramp.timeseries_ramp.PhetTimer;
import edu.colorado.phet.theramp.timeseries_ramp.PlaybackMode;
import edu.colorado.phet.theramp.timeseries_ramp.RecordMode;
import edu.colorado.phet.theramp.timeseries_ramp.TimeSeriesModelListener;
import java.util.ArrayList;

public abstract class TimeSeriesModel
extends ClockTickListener {
    private ArrayList listeners = new ArrayList();
    private boolean paused = true;
    private Mode mode;
    private RecordMode recordMode = new RecordMode(this);
    private PlaybackMode playbackMode = new PlaybackMode(this);
    public static double TIME_SCALE = 1.0;
    private double maxAllowedTime;

    public TimeSeriesModel(double d) {
        this.maxAllowedTime = d;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void addPlaybackTimeChangeListener(final PlaybackTimeListener playbackTimeListener) {
        this.getPlaybackTimer().addListener(new PhetTimer.Listener(){

            public void timeChanged() {
                playbackTimeListener.timeChanged();
            }
        });
    }

    public double getPlaybackTime() {
        return this.getPlaybackTimer().getTime();
    }

    public void setReplayTime(double d) {
        if (d < 0.0 || d > this.getRecordTime()) {
            return;
        }
        this.getPlaybackTimer().setTime(d);
    }

    public abstract void repaintBackground();

    public PhetTimer getRecordTimer() {
        return this.recordMode.getTimer();
    }

    public PhetTimer getPlaybackTimer() {
        return this.playbackMode.getTimer();
    }

    public void fireReset() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeSeriesModelListener timeSeriesModelListener = (TimeSeriesModelListener)this.listeners.get(i);
            timeSeriesModelListener.reset();
        }
    }

    private void firePause() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeSeriesModelListener timeSeriesModelListener = (TimeSeriesModelListener)this.listeners.get(i);
            if (this.mode == this.recordMode) {
                timeSeriesModelListener.recordingPaused();
                continue;
            }
            timeSeriesModelListener.playbackPaused();
        }
    }

    public void firePlaybackFinished() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeSeriesModelListener timeSeriesModelListener = (TimeSeriesModelListener)this.listeners.get(i);
            timeSeriesModelListener.playbackFinished();
        }
    }

    public void addListener(TimeSeriesModelListener timeSeriesModelListener) {
        this.listeners.add(timeSeriesModelListener);
    }

    public double getRecordTime() {
        return this.getRecordTimer().getTime();
    }

    public void setPaused(boolean bl) {
        if (bl != this.paused) {
            this.paused = bl;
            if (bl) {
                this.firePause();
            } else if (this.isRecording()) {
                this.fireRecordStarted();
            } else if (this.isPlayback()) {
                this.firePlaybackStarted();
            }
        }
    }

    private void firePlaybackStarted() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeSeriesModelListener timeSeriesModelListener = (TimeSeriesModelListener)this.listeners.get(i);
            timeSeriesModelListener.playbackStarted();
        }
    }

    private boolean isPlayback() {
        return this.mode == this.playbackMode;
    }

    private void fireRecordStarted() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeSeriesModelListener timeSeriesModelListener = (TimeSeriesModelListener)this.listeners.get(i);
            timeSeriesModelListener.recordingStarted();
        }
    }

    public void reset() {
        this.setPaused(true);
        this.recordMode.reset();
        this.playbackMode.reset();
        this.fireReset();
    }

    public boolean isRecordMode() {
        return this.mode == this.recordMode;
    }

    public void setRecordMode() {
        this.setMode(this.recordMode);
    }

    public void confirmAndApplyReset() {
        if (this.confirmReset()) {
            this.reset();
        }
    }

    protected abstract boolean confirmReset();

    public void setMode(Mode mode) {
        boolean bl;
        boolean bl2 = bl = mode == this.mode;
        if (!bl) {
            this.mode = mode;
            this.mode.initialize();
            System.out.println("Changed mode to: " + mode.getName());
        }
    }

    private void fireRewind() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeSeriesModelListener timeSeriesModelListener = (TimeSeriesModelListener)this.listeners.get(i);
            timeSeriesModelListener.rewind();
        }
    }

    public void rewind() {
        this.playbackMode.rewind();
        this.fireRewind();
    }

    public void startPlaybackMode(double d) {
        this.playbackMode.setPlaybackSpeed(d);
        this.setMode(this.playbackMode);
        this.setPaused(false);
    }

    public boolean isRecording() {
        return this.mode == this.recordMode && !this.isPaused();
    }

    public abstract void updateModel(ClockEvent var1);

    public double getMaxAllowedTime() {
        return this.maxAllowedTime;
    }

    public double getTime() {
        if (this.isRecordMode()) {
            return this.getRecordTime();
        }
        return this.getPlaybackTime();
    }

    public void clockTicked(ClockEvent clockEvent) {
        if (this.mode != null) {
            this.mode.clockTicked(clockEvent);
        }
    }

    public static interface PlaybackTimeListener {
        public void timeChanged();
    }
}

