/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetDefaultFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.theramp.view.SurfaceGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class AngleGraphic
extends PNode {
    private SurfaceGraphic surfaceGraphic;
    private PPath phetShapeGraphic;
    private HTMLNode label;

    public AngleGraphic(SurfaceGraphic surfaceGraphic) {
        this.surfaceGraphic = surfaceGraphic;
        this.phetShapeGraphic = new PPath(null);
        this.phetShapeGraphic.setStroke(new BasicStroke(2.0f));
        this.phetShapeGraphic.setStrokePaint(Color.black);
        this.label = new HTMLNode("test");
        this.label.setFont(new PhetDefaultFont(14));
        this.addChild(this.phetShapeGraphic);
        this.addChild(this.label);
        this.update();
    }

    public void update() {
        Point point = this.surfaceGraphic.getViewLocation(0.0);
        Point point2 = this.getGroundLocationView(5.0);
        int n = (point2.x - point.x) * 2;
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double_.setFrameFromCenter(point, new Point2D.Double(point.x + n / 2, point.y + n / 2));
        double d = this.surfaceGraphic.getSurface().getAngle() * 180.0 / Math.PI;
        d = Math.max(d, 1.0E-5);
        Arc2D.Double double_2 = new Arc2D.Double(double_, 0.0, d, 0);
        this.phetShapeGraphic.setPathTo(double_2);
        this.label.setOffset(double_2.getBounds().getMaxX(), double_2.getBounds().getY() + double_2.getBounds().getHeight() / 2.0 + 20.0);
        this.label.setHTML("" + this.getAngleMessage());
    }

    private String getAngleMessage() {
        double d = this.surfaceGraphic.getSurface().getAngle() * 180.0 / Math.PI;
        String string = "<html>" + new DecimalFormat("0.0").format(d) + "<sup>o</sup></html>";
        return string;
    }

    private Point getGroundLocationView(double d) {
        Point2D point2D = this.surfaceGraphic.getSurface().getOrigin();
        Point2D.Double double_ = new Point2D.Double(point2D.getX() + d, point2D.getY());
        return this.surfaceGraphic.getViewLocation(double_);
    }
}

