/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AppliedForceSimpleControl
extends PNode {
    private RampModule module;
    private RampPanel rampPanel;

    public AppliedForceSimpleControl(final RampModule rampModule, RampPanel rampPanel) {
        this.module = rampModule;
        this.rampPanel = rampPanel;
        double d = 3000.0;
        HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.add(new JLabel(TheRampStrings.getString("forces.applied.n")));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(rampModule.getRampPhysicalModel().getAppliedForceScalar(), -d, d, 100.0);
        final JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        jSpinner.setEditor(new JSpinner.NumberEditor(jSpinner, "0.00"));
        verticalLayoutPanel.add(jSpinner);
        horizontalLayoutPanel.add(verticalLayoutPanel);
        PSwing pSwing = new PSwing(horizontalLayoutPanel);
        this.addChild(pSwing);
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Number number = (Number)jSpinner.getValue();
                rampModule.setAppliedForce(number.doubleValue());
            }
        });
        rampModule.getRampPhysicalModel().addListener(new RampPhysicalModel.Adapter(){

            public void appliedForceChanged() {
                Double d = new Double(rampModule.getRampPhysicalModel().getAppliedForceScalar());
                if (!jSpinner.getValue().equals(d)) {
                    jSpinner.setValue(d);
                    AppliedForceSimpleControl.this.repaint();
                }
            }
        });
    }
}

