/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.MakeDuotoneImageOp;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.model.Block;
import edu.colorado.phet.theramp.model.Ramp;
import edu.colorado.phet.theramp.model.RampObject;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.colorado.phet.theramp.view.SurfaceGraphic;
import edu.colorado.phet.theramp.view.ThresholdedPDragAdapter;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class BlockGraphic
extends PNode {
    private RampModule module;
    private RampPanel rampPanel;
    private SurfaceGraphic rampGraphic;
    private SurfaceGraphic groundGraphic;
    private Block block;
    private PImage imageGraphic;
    private RampObject rampObject;
    private PImage wheelGraphic;
    private double viewScale = 0.5;
    private double scaleDownInputForces = 0.1;

    public BlockGraphic(final RampModule rampModule, RampPanel rampPanel, SurfaceGraphic surfaceGraphic, SurfaceGraphic surfaceGraphic2, Block block, RampObject rampObject) {
        this.module = rampModule;
        this.rampPanel = rampPanel;
        this.rampGraphic = surfaceGraphic;
        this.groundGraphic = surfaceGraphic2;
        this.block = block;
        this.rampObject = rampObject;
        final RampPhysicalModel rampPhysicalModel = rampModule.getRampPhysicalModel();
        try {
            this.wheelGraphic = new PImage(ImageLoader.loadBufferedImage("the-ramp/images/skateboard.png"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.imageGraphic = new PImage();
        this.addChild(this.imageGraphic);
        this.setObject(rampObject);
        block.addListener(new Block.Adapter(){

            public void positionChanged() {
                BlockGraphic.this.updateBlock();
            }

            public void massChanged() {
                BlockGraphic.this.updateBlock();
            }

            public void staticFrictionChanged() {
                BlockGraphic.this.updateBlock();
            }

            public void kineticFrictionChanged() {
                BlockGraphic.this.updateBlock();
            }
        });
        PBasicInputEventHandler pBasicInputEventHandler = new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                super.mouseDragged(pInputEvent);
                double d = pInputEvent.getPositionRelativeTo(BlockGraphic.this.imageGraphic).getX();
                double d2 = BlockGraphic.this.imageGraphic.getBounds().getCenterX();
                double d3 = d - d2;
                double d4 = d3 / 0.06 * BlockGraphic.this.viewScale * BlockGraphic.this.scaleDownInputForces;
                rampPhysicalModel.setAppliedForce(d4);
                rampModule.record();
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                super.mouseReleased(pInputEvent);
                rampPhysicalModel.setAppliedForce(0.0);
            }
        };
        ThresholdedPDragAdapter thresholdedPDragAdapter = new ThresholdedPDragAdapter(pBasicInputEventHandler, 10, 0, 1000L);
        this.addInputEventListener(thresholdedPDragAdapter);
        this.addInputEventListener(new CursorHandler(12));
        surfaceGraphic.getSurface().addObserver(new SimpleObserver(){

            public void update() {
                BlockGraphic.this.updateBlock();
            }
        });
        this.imageGraphic.setPaint(Color.black);
    }

    public void updateBlock() {
        double d = this.block.getMass();
        double d2 = this.rampObject.getScale();
        double d3 = this.rampObject.getMass();
        double d4 = d2 * d / d3;
        AffineTransform affineTransform = this.createTransform(d2, d4);
        affineTransform.concatenate(AffineTransform.getScaleInstance(d2, d4));
        affineTransform.concatenate(AffineTransform.getTranslateInstance(0.0, this.getOffsetYPlease()));
        this.imageGraphic.setTransform(affineTransform);
        if (this.isFrictionless()) {
            if (!this.isAncestorOf(this.wheelGraphic)) {
                this.addChild(0, this.wheelGraphic);
            }
            this.wheelGraphic.setVisible(true);
            AffineTransform affineTransform2 = this.createTransform(this.block.getPositionInSurface(), 1.0, 1.0, this.wheelGraphic.getImage().getWidth(null), this.wheelGraphic.getImage().getHeight(null));
            this.wheelGraphic.setTransform(affineTransform2);
        } else if (this.isAncestorOf(this.wheelGraphic)) {
            this.removeChild(this.wheelGraphic);
        }
        this.repaint();
    }

    private boolean isFrictionless() {
        return this.block.getStaticFriction() == 0.0 || this.block.getKineticFriction() == 0.0;
    }

    private double getOffsetYPlease() {
        if (this.isFrictionless()) {
            return this.rampObject.getYOffset() - this.getSkateboardHeight();
        }
        return this.rampObject.getYOffset();
    }

    private double getSkateboardHeight() {
        return this.wheelGraphic.getImage().getHeight(null);
    }

    private AffineTransform createTransform(double d, double d2, double d3, int n, int n2) {
        return this.getCurrentSurfaceGraphic().createTransform(d, new Dimension((int)((double)n * d2), (int)((double)n2 * d3)));
    }

    private AffineTransform createTransform(double d, double d2) {
        return this.getCurrentSurfaceGraphic().createTransform(this.block.getPositionInSurface(), new Dimension((int)((double)this.imageGraphic.getImage().getWidth(null) * d), (int)((double)this.imageGraphic.getImage().getHeight(null) * d2)));
    }

    private void setImage(BufferedImage bufferedImage) {
        this.imageGraphic.setImage(bufferedImage);
        this.updateBlock();
    }

    public int getObjectWidthView() {
        return (int)((double)this.imageGraphic.getImage().getWidth(null) * this.rampObject.getScale());
    }

    public Block getBlock() {
        return this.block;
    }

    public void setObject(RampObject rampObject) {
        this.rampObject = rampObject;
        try {
            this.setImage(rampObject.getImage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.updateBlock();
    }

    public SurfaceGraphic getCurrentSurfaceGraphic() {
        if (this.block.getSurface() instanceof Ramp) {
            return this.rampGraphic;
        }
        return this.groundGraphic;
    }

    public PImage getObjectGraphic() {
        return this.imageGraphic;
    }

    public PBounds getBlockBounds() {
        return this.imageGraphic.getFullBounds();
    }

    public void paintRed() {
        System.out.println("BlockGraphic.paintRed");
        MakeDuotoneImageOp makeDuotoneImageOp = new MakeDuotoneImageOp(Color.red);
        BufferedImage bufferedImage = makeDuotoneImageOp.filter((BufferedImage)this.imageGraphic.getImage(), null);
        this.imageGraphic.setImage(bufferedImage);
    }

    public void restoreOriginalImage() {
        System.out.println("BlockGraphic.restoreOriginalImage");
        try {
            this.setImage(this.rampObject.getImage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

