/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Particle;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.view.EarthGraphic;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class FireDog
extends PNode {
    private PImage image;
    private RampModule module;
    BufferedImage dropImage;
    ArrayList waterDrops = new ArrayList();
    Random random = new Random();

    public FireDog(RampModule rampModule) {
        this.module = rampModule;
        try {
            BufferedImage bufferedImage = ImageLoader.loadBufferedImage("the-ramp/images/firedog.gif");
            bufferedImage = BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage, 100);
            this.image = new PImage(bufferedImage);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addChild(this.image);
        this.initImage();
    }

    private void initImage() {
        this.image.setTransform(new AffineTransform());
        this.image.setOffset(-this.image.getWidth(), this.getFloorY() - this.image.getFullBounds().getHeight() + 3.0);
    }

    private double getRampX() {
        PBounds pBounds = this.module.getRampPanel().getRampWorld().getRampGraphic().getGlobalFullBounds();
        return this.globalToLocal(pBounds).getMaxY();
    }

    private double getFloorY() {
        EarthGraphic earthGraphic = this.module.getRampPanel().getRampWorld().getEarthGraphic();
        Point2D point2D = earthGraphic.getGlobalFullBounds().getOrigin();
        this.globalToLocal(point2D);
        this.localToParent(point2D);
        return point2D.getY();
    }

    private void addWaterDrop() {
        WaterDrop waterDrop = new WaterDrop();
        this.getRampPanel().addWorldChild(waterDrop);
        waterDrop.finishInit();
        this.waterDrops.add(waterDrop);
    }

    public void putOutFire() {
        this.getRampPanel().addWorldChild(this);
        this.finishInit();
        this.getRampPanel().getRoot().addActivity(new MoveToFire());
    }

    private void finishInit() {
        this.initImage();
    }

    private RampPanel getRampPanel() {
        RampPanel rampPanel = this.module.getRampPanel();
        return rampPanel;
    }

    class WaterDrop
    extends PNode {
        Particle particle = new Particle();

        public WaterDrop() {
            if (FireDog.this.dropImage == null) {
                try {
                    FireDog.this.dropImage = ImageLoader.loadBufferedImage("the-ramp/images/drop3.gif");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            PImage pImage = new PImage(FireDog.this.dropImage);
            pImage.scale(0.35);
            this.addChild(pImage);
            this.fixLocation();
            double d = FireDog.this.random.nextGaussian() * 30.0;
            double d2 = FireDog.this.random.nextGaussian() * 20.0;
            this.particle.setVelocity(200.0 + d, -120.0 - d2);
            this.particle.setAcceleration(0.0, 200.0);
        }

        public void finishInit() {
            this.fixLocation();
        }

        private void fixLocation() {
            Point2D.Double double_ = new Point2D.Double(FireDog.this.image.getGlobalFullBounds().getMaxX(), FireDog.this.image.getGlobalFullBounds().getCenterY() + 20.0);
            this.particle.setPosition(this.globalToLocal(double_));
        }

        public void propagate(double d) {
            this.particle.stepInTime(d);
            this.update();
        }

        private void update() {
            this.setTransform(new AffineTransform());
            this.setOffset(this.particle.getPosition());
            Vector2D vector2D = this.particle.getVelocity();
            double d = vector2D.getAngle();
            this.rotate(d - 1.5707963267948966);
            if (this.particle.getPosition().getY() > FireDog.this.getFloorY()) {
                FireDog.this.getRampPanel().removeWorldChild(this);
                FireDog.this.waterDrops.remove(this);
                FireDog.this.module.getRampPhysicalModel().clearHeat();
            }
        }
    }

    private class WalkAway
    extends PActivity {
        public WalkAway() {
            super(2500L);
            FireDog.this.image.setImage(BufferedImageUtils.flipX((BufferedImage)FireDog.this.image.getImage()));
        }

        protected void activityStep(long l) {
            super.activityStep(l);
            FireDog.this.translate(-6.0, 0.0);
        }

        protected void activityFinished() {
            FireDog.this.getRampPanel().removeWorldChild(FireDog.this);
            FireDog.this.module.firedogFinished();
        }
    }

    private class ExpelWater
    extends PActivity {
        public ExpelWater() {
            super(1250L);
        }

        protected void activityStep(long l) {
            super.activityStep(l);
            FireDog.this.addWaterDrop();
            FireDog.this.addWaterDrop();
            FireDog.this.addWaterDrop();
        }

        protected void activityFinished() {
            FireDog.this.getRampPanel().getRoot().addActivity(new WalkAway());
        }
    }

    private class MoveWater
    extends PActivity {
        long lastTime;

        public MoveWater() {
            super(-1L);
            this.lastTime = -1L;
        }

        protected void activityStep(long l) {
            super.activityStep(l);
            double d = this.lastTime == -1L ? (double)this.getStepRate() / 1000.0 : (double)(l - this.lastTime) / 1000.0;
            d *= 1.3;
            for (int i = 0; i < FireDog.this.waterDrops.size(); ++i) {
                WaterDrop waterDrop = (WaterDrop)FireDog.this.waterDrops.get(i);
                waterDrop.propagate(d);
            }
            if (FireDog.this.waterDrops.size() == 0) {
                FireDog.this.getRampPanel().getRoot().getActivityScheduler().removeActivity(this);
            }
            this.lastTime = l;
        }
    }

    private class MoveToFire
    extends PActivity {
        private double randomInset;
        private double runToFireSpeed;

        public MoveToFire() {
            super(-1L);
            this.runToFireSpeed = 23.0;
            this.randomInset = FireDog.this.random.nextGaussian() * 45.0;
        }

        protected void activityStep(long l) {
            super.activityStep(l);
            FireDog.this.translate(this.runToFireSpeed, 0.0);
            if (FireDog.this.getOffset().getX() > FireDog.this.getRampX() - this.randomInset) {
                this.terminate();
            }
        }

        protected void activityFinished() {
            super.activityFinished();
            FireDog.this.addWaterDrop();
            FireDog.this.getRampPanel().getRoot().addActivity(new ExpelWater());
            FireDog.this.getRampPanel().getRoot().addActivity(new MoveWater());
        }
    }
}

