/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.RampTimeSeriesModel;
import edu.colorado.phet.theramp.timeseries_ramp.TimeSeriesModel;
import edu.colorado.phet.theramp.timeseries_ramp.TimeSeriesModelListenerAdapter;
import edu.colorado.phet.theramp.view.EarthGraphic;
import edu.colorado.phet.theramp.view.RampFontSet;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class GoPauseClearPanel
extends VerticalLayoutPanel {
    private TimeSeriesModel module;
    private JButton goPauseButton;
    private JButton clearButton;
    private boolean itsAGoButton = true;
    private ImageIcon goIcon;
    private ImageIcon pauseIcon;

    public GoPauseClearPanel(final TimeSeriesModel timeSeriesModel) {
        this.module = timeSeriesModel;
        super.getGridBagConstraints().anchor = 10;
        final ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                timeSeriesModel.setPaused(true);
            }
        };
        this.goPauseButton = new ControlButton(TheRampStrings.getString("time.pause"));
        try {
            this.goIcon = new ImageIcon(ImageLoader.loadBufferedImage("the-ramp/images/light3.png"));
            this.pauseIcon = new ImageIcon(ImageLoader.loadBufferedImage("the-ramp/images/stop-20.png"));
            this.goPauseButton.setIcon(this.goIcon);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        final ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                timeSeriesModel.setRecordMode();
                timeSeriesModel.setPaused(false);
            }
        };
        this.goPauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GoPauseClearPanel.this.itsAGoButton) {
                    actionListener2.actionPerformed(actionEvent);
                } else {
                    actionListener.actionPerformed(actionEvent);
                }
            }
        });
        this.clearButton = new ControlButton(TheRampStrings.getString("controls.clear"));
        this.clearButton.setBackground(EarthGraphic.earthGreen);
        this.setBackground(EarthGraphic.earthGreen);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                timeSeriesModel.confirmAndApplyReset();
            }
        });
        timeSeriesModel.addListener(new TimeSeriesModelListenerAdapter(){

            public void recordingStarted() {
                GoPauseClearPanel.this.setButtons(false, true, true);
            }

            public void recordingPaused() {
                GoPauseClearPanel.this.setButtons(true, false, true);
            }

            public void reset() {
                GoPauseClearPanel.this.setButtons(true, false, false);
            }

            public void rewind() {
                GoPauseClearPanel.this.setButtons(true, false, true);
            }
        });
        this.add(this.goPauseButton);
        this.add(this.clearButton);
        this.setButtons(true, false, false);
    }

    private void setButtons(boolean bl, boolean bl2, boolean bl3) {
        if (bl2 && bl || bl2 || !bl) {
            // empty if block
        }
        if (bl2) {
            this.goPauseButton.setText(TheRampStrings.getString("time.pause"));
            this.goPauseButton.setIcon(this.pauseIcon);
            this.paintAll();
            this.itsAGoButton = false;
        } else {
            this.goPauseButton.setText("     " + TheRampStrings.getString("time.go"));
            this.goPauseButton.setIcon(this.goIcon);
            this.paintAll();
            this.itsAGoButton = true;
        }
        this.clearButton.setEnabled(bl3);
        this.repaintComponents();
    }

    private void paintAll() {
        RampTimeSeriesModel rampTimeSeriesModel;
        super.invalidate();
        super.validate();
        super.doLayout();
        super.repaint();
        this.goPauseButton.repaint();
        this.clearButton.repaint();
        this.clearButton.repaint(0, 0, this.clearButton.getWidth(), this.clearButton.getHeight());
        if (this.module instanceof RampTimeSeriesModel && (rampTimeSeriesModel = (RampTimeSeriesModel)this.module).getRampModule() != null && rampTimeSeriesModel.getRampModule().getRampPanel() != null) {
            rampTimeSeriesModel.getRampModule().getRampPanel().repaint();
        }
    }

    private void repaintComponents() {
        this.goPauseButton.repaint();
        this.clearButton.repaint();
        this.repaint();
    }

    static class ControlButton
    extends JButton {
        private static Font font = RampFontSet.getFontSet().getNormalButtonFont();

        public ControlButton(String string) {
            super(string);
            this.setFont(font);
            this.setBackground(EarthGraphic.earthGreen);
        }
    }
}

