/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.view.RampFontSet;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RectangularShape;
import javax.swing.JButton;

public class OverheatButton
extends PNode {
    private RampPhysicalModel rampPhysicalModel;
    private RampPanel rampPanel;
    private RampModule module;

    public OverheatButton(final RampPanel rampPanel, RampPhysicalModel rampPhysicalModel, RampModule rampModule) {
        this.module = rampModule;
        this.rampPhysicalModel = rampPhysicalModel;
        this.rampPanel = rampPanel;
        ShadowHTMLNode shadowHTMLNode = new ShadowHTMLNode(TheRampStrings.getString("message.overheated"));
        shadowHTMLNode.setColor(Color.red);
        shadowHTMLNode.setFont(new Font("Lucida Sans", 1, 14));
        this.addChild(shadowHTMLNode);
        JButton jButton = new JButton(TheRampStrings.getString("controls.cool-ramp"));
        jButton.setFont(RampFontSet.getFontSet().getNormalButtonFont());
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rampPanel.getRampModule().clearHeat();
            }
        });
        PSwing pSwing = new PSwing(jButton);
        pSwing.setOffset(0.0, shadowHTMLNode.getHeight());
        this.addChild(pSwing);
        rampModule.getModel().addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                OverheatButton.this.update();
            }
        });
        this.update();
        pSwing.setOffset(0.0, shadowHTMLNode.getFullBounds().getHeight() + 5.0);
    }

    private void update() {
        double d = this.rampPanel.getOverheatEnergy();
        if (this.rampPhysicalModel.getThermalEnergy() >= d && !this.getVisible() && this.module.numMaximizedBarGraphs() > 0) {
            this.setVisible(true);
            this.setPickable(true);
            this.setChildrenPickable(true);
            PBounds pBounds = this.rampPanel.getBarGraphSuite().getGlobalFullBounds();
            this.globalToLocal(pBounds);
            this.localToParent(pBounds);
            this.setOffset(((RectangularShape)pBounds).getX() + 20.0, this.rampPanel.getHeight() / 2);
        } else if (this.rampPhysicalModel.getThermalEnergy() < d) {
            this.setVisible(false);
            this.setPickable(false);
            this.setChildrenPickable(false);
        }
    }
}

