/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.colorado.phet.theramp.view.RampWorld;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;

public class PotentialEnergyZeroGraphic
extends PNode {
    private RampPhysicalModel rampPhysicalModel;
    private RampWorld rampWorld;
    private RampPanel rampPanel;
    private PPath phetShapeGraphic;
    private PText label;

    public PotentialEnergyZeroGraphic(RampPanel rampPanel, final RampPhysicalModel rampPhysicalModel, final RampWorld rampWorld) {
        this.rampPanel = rampPanel;
        this.rampPhysicalModel = rampPhysicalModel;
        this.rampWorld = rampWorld;
        this.phetShapeGraphic = new PPath(new Line2D.Double(0.0, 0.0, 1000.0, 0.0), new BasicStroke(4.0f, 1, 1, 1.0f, new float[]{20.0f, 20.0f}, 0.0f));
        this.phetShapeGraphic.setPaint(Color.black);
        this.addChild(this.phetShapeGraphic);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                PotentialEnergyZeroGraphic.this.changeZeroPoint(pInputEvent);
            }
        });
        RampPhysicalModel.Adapter adapter = new RampPhysicalModel.Adapter(){

            public void zeroPointChanged() {
                PotentialEnergyZeroGraphic.this.setOffset(0.0, rampWorld.getRampGraphic().getScreenTransform().modelToViewY(rampPhysicalModel.getZeroPointY()));
                PotentialEnergyZeroGraphic.this.updateLabel();
            }
        };
        rampPhysicalModel.addListener(adapter);
        this.label = new PText(TheRampStrings.getString("indicator.height-unknown"));
        this.addChild(this.label);
        this.label.setFont(new Font("Lucida Sans", 1, 18));
        this.label.setOffset(10.0, this.label.getHeight());
        this.addInputEventListener(new CursorHandler(12));
        this.updateLabel();
        rampPhysicalModel.setZeroPointY(0.0);
    }

    private void updateLabel() {
        String string = new DecimalFormat("0.0").format(this.rampPhysicalModel.getZeroPointY());
        this.label.setText(MessageFormat.format(TheRampStrings.getString("indicator.height"), string));
    }

    private void changeZeroPoint(PInputEvent pInputEvent) {
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.rampWorld);
        double d = this.rampPanel.getRampGraphic().getScreenTransform().viewToModelY(point2D.getY());
        this.rampPhysicalModel.setZeroPointY(d);
    }
}

