/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.FrameSequence;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.common.PhetAudioClip;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.colorado.phet.theramp.view.RampWorld;
import edu.colorado.phet.theramp.view.SurfaceGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class PusherGraphic
extends PImage {
    private FrameSequence animation;
    private PNode target;
    private RampWorld rampWorld;
    private double max = 3000.0;
    private FrameSequence flippedAnimation;
    private BufferedImage standingStill;
    private RampModule module;
    private RampPanel rampPanel;
    private double modelLocation;
    private ModelElement runOver;
    private double lastDX;
    private boolean crushed = false;
    private long crushTime = 0L;
    private BufferedImage crushedManImage;
    private double lastAppliedForce = 0.0;
    private PhetAudioClip slapSound;

    public PusherGraphic(RampPanel rampPanel, PNode pNode, RampWorld rampWorld) throws IOException {
        this.target = pNode;
        this.rampWorld = rampWorld;
        this.module = rampPanel.getRampModule();
        this.rampPanel = rampPanel;
        this.standingStill = ImageLoader.loadBufferedImage("the-ramp/images/standing-man.png");
        this.animation = new FrameSequence("the-ramp/images/pusher-leaner-png/pusher-leaning-2", "png", 15);
        BufferedImage[] bufferedImageArray = new BufferedImage[this.animation.getNumFrames()];
        for (int i = 0; i < bufferedImageArray.length; ++i) {
            bufferedImageArray[i] = BufferedImageUtils.flipX(this.animation.getFrame(i));
        }
        this.flippedAnimation = new FrameSequence(bufferedImageArray);
        super.setImage(this.animation.getFrame(0));
        this.module.getRampPhysicalModel().addListener(new RampPhysicalModel.Adapter(){

            public void appliedForceChanged() {
                PusherGraphic.this.update();
            }
        });
        this.module.getRampPhysicalModel().getRamp().addObserver(new SimpleObserver(){

            public void update() {
                PusherGraphic.this.updateTransform();
            }
        });
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.update();
        this.runOver = new ModelElement(){

            public void stepInTime(double d) {
                double d2 = PusherGraphic.this.getBlockDx();
                if (PusherGraphic.this.getAppliedForce() == 0.0 && PusherGraphic.this.lastAppliedForce == 0.0 && PusherGraphic.this.signDiffers(d2, PusherGraphic.this.lastDX) && !PusherGraphic.this.crushed) {
                    PusherGraphic.this.crushMan();
                } else if (PusherGraphic.this.crushed && PusherGraphic.this.timeSinceCrush() > 1000L) {
                    PusherGraphic.this.standUp();
                }
                PusherGraphic.this.lastDX = d2;
                PusherGraphic.this.lastAppliedForce = PusherGraphic.this.getAppliedForce();
            }
        };
        this.module.getModel().addModelElement(this.runOver);
        this.lastDX = this.getBlockDx();
        this.modelLocation = this.getSurfaceGraphic().getSurface().getLength() / 2.0;
        this.slapSound = new PhetAudioClip("the-ramp/audio/slapooh.wav");
    }

    private long timeSinceCrush() {
        return System.currentTimeMillis() - this.crushTime;
    }

    private void standUp() {
        if (this.getAppliedForce() == 0.0) {
            this.setImage(this.standingStill);
        }
        this.crushed = false;
    }

    private Image getCrushedManImage() {
        if (this.crushedManImage == null) {
            try {
                this.crushedManImage = ImageLoader.loadBufferedImage("the-ramp/images/crushedman.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.crushedManImage;
    }

    private void crushMan() {
        System.out.println("CRUSH_MAN ");
        this.crushed = true;
        this.crushTime = System.currentTimeMillis();
        this.setImage(this.getCrushedManImage());
        this.slapSound.play();
    }

    private boolean signDiffers(double d, double d2) {
        return d > 0.0 && d2 < 0.0 || d < 0.0 && d2 > 0.0;
    }

    private double getBlockDx() {
        return this.modelLocation - this.getBlockLocation();
    }

    private double getAppliedForce() {
        return this.module.getRampPhysicalModel().getAppliedForce().getParallelComponent();
    }

    private BufferedImage getFrame(boolean bl) {
        double d = Math.abs(this.getAppliedForce());
        int n = (int)((double)this.animation.getNumFrames() * d / this.max);
        if (n >= this.animation.getNumFrames()) {
            n = this.animation.getNumFrames() - 1;
        }
        if (this.getAppliedForce() == 0.0) {
            return this.standingStill;
        }
        if (bl) {
            return this.animation.getFrame(n);
        }
        return this.flippedAnimation.getFrame(n);
    }

    private void update() {
        this.syncWithBlock();
        this.updateTransform();
    }

    private void syncWithBlock() {
        BufferedImage bufferedImage;
        boolean bl = true;
        double d = this.getAppliedForce();
        if (d < 0.0) {
            bl = false;
        }
        if (!((bufferedImage = this.getFrame(bl)) == this.getImage() || d == 0.0 && this.crushed && this.timeSinceCrush() < 1000L)) {
            this.setImage(bufferedImage);
        }
        double d2 = this.rampWorld.getBlockWidthModel();
        double d3 = this.rampWorld.getModelWidth(bufferedImage.getWidth());
        double d4 = 0.0;
        d4 = bl ? this.getBlockLocation() - (d3 + d2) / 2.0 : this.getBlockLocation() + (d3 + d2) / 2.0;
        if (d != 0.0) {
            this.modelLocation = d4;
        }
    }

    private double getBlockLocation() {
        return this.rampWorld.getBlockGraphic().getBlock().getPosition();
    }

    private void updateTransform() {
        double d = this.getPositionInSurface();
        AffineTransform affineTransform = this.getSurfaceGraphic().createTransform(d, new Dimension(this.getFrame().getWidth(null), this.getFrame().getHeight(null)));
        if (!this.getTransform().equals(affineTransform)) {
            this.setTransform(affineTransform);
        }
    }

    private double getPositionInSurface() {
        if (this.getSurfaceGraphic() == this.rampWorld.getGroundGraphic()) {
            return this.modelLocation;
        }
        return this.modelLocation - this.rampWorld.getGroundGraphic().getSurface().getLength();
    }

    private SurfaceGraphic getSurfaceGraphic() {
        return this.rampWorld.getSurfaceGraphic(this.modelLocation);
    }

    private Image getFrame() {
        return this.getImage();
    }
}

