/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.common.MeasuringTape;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.model.Surface;
import edu.colorado.phet.theramp.view.BlockGraphic;
import edu.colorado.phet.theramp.view.EarthGraphic;
import edu.colorado.phet.theramp.view.FloorGraphic;
import edu.colorado.phet.theramp.view.LeftBarrierGraphic;
import edu.colorado.phet.theramp.view.PotentialEnergyZeroGraphic;
import edu.colorado.phet.theramp.view.PusherGraphic;
import edu.colorado.phet.theramp.view.RampGraphic;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.colorado.phet.theramp.view.RightBarrierGraphic;
import edu.colorado.phet.theramp.view.SkyGraphic;
import edu.colorado.phet.theramp.view.SurfaceGraphic;
import edu.colorado.phet.theramp.view.arrows.AbstractArrowSet;
import edu.colorado.phet.theramp.view.arrows.CartesianArrowSet;
import edu.colorado.phet.theramp.view.arrows.ParallelArrowSet;
import edu.colorado.phet.theramp.view.arrows.PerpendicularArrowSet;
import edu.colorado.phet.theramp.view.arrows.XArrowSet;
import edu.colorado.phet.theramp.view.arrows.YArrowSet;
import edu.umd.cs.piccolo.PNode;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;

public class RampWorld
extends PNode {
    private ArrayList arrowSets = new ArrayList();
    private SurfaceGraphic rampGraphic;
    private BlockGraphic blockGraphic;
    private AbstractArrowSet cartesian;
    private AbstractArrowSet perp;
    private AbstractArrowSet parallel;
    private XArrowSet xArrowSet;
    private YArrowSet yArrowSet;
    private PotentialEnergyZeroGraphic potentialEnergyZeroGraphic;
    private PusherGraphic pusherGraphic;
    private EarthGraphic earthGraphic;
    private SkyGraphic skyGraphic;
    private FloorGraphic groundGraphic;
    private MeasuringTape measuringTape;
    private RightBarrierGraphic rightBarrierGraphic;
    private LeftBarrierGraphic leftBarrierGraphic;
    private RampModule module;
    boolean heatColor = false;

    public RampWorld(RampModule rampModule, RampPanel rampPanel) {
        this.module = rampModule;
        RampPhysicalModel rampPhysicalModel = rampModule.getRampPhysicalModel();
        Surface surface = rampPhysicalModel.getRamp();
        this.rampGraphic = new RampGraphic(rampPanel, surface);
        this.earthGraphic = new EarthGraphic(rampPanel, this);
        this.skyGraphic = new SkyGraphic(rampPanel, this);
        this.groundGraphic = new FloorGraphic(rampPanel, rampPhysicalModel.getGround());
        this.blockGraphic = new BlockGraphic(rampModule, rampPanel, this.rampGraphic, this.groundGraphic, rampPhysicalModel.getBlock(), rampModule.getRampObjects()[0]);
        this.rightBarrierGraphic = new RightBarrierGraphic(rampPanel, rampPanel, this.rampGraphic);
        this.leftBarrierGraphic = new LeftBarrierGraphic(rampPanel, rampPanel, this.groundGraphic);
        this.addChild(this.skyGraphic);
        this.addChild(this.earthGraphic);
        this.addChild(this.rampGraphic);
        this.addChild(this.groundGraphic);
        this.addChild(this.leftBarrierGraphic);
        this.addChild(this.rightBarrierGraphic);
        this.addChild(this.blockGraphic);
        this.cartesian = new CartesianArrowSet(rampPanel, this.getBlockGraphic());
        this.perp = new PerpendicularArrowSet(rampPanel, this.getBlockGraphic());
        this.parallel = new ParallelArrowSet(rampPanel, this.getBlockGraphic());
        this.xArrowSet = new XArrowSet(rampPanel, this.getBlockGraphic());
        this.yArrowSet = new YArrowSet(rampPanel, this.getBlockGraphic());
        this.addArrowSet(this.cartesian);
        this.addArrowSet(this.perp);
        this.addArrowSet(this.parallel);
        this.addArrowSet(this.xArrowSet);
        this.addArrowSet(this.yArrowSet);
        this.perp.setVisible(false);
        this.parallel.setVisible(false);
        this.xArrowSet.setVisible(false);
        this.yArrowSet.setVisible(false);
        this.potentialEnergyZeroGraphic = new PotentialEnergyZeroGraphic(rampPanel, rampPhysicalModel, this);
        this.addChild(this.potentialEnergyZeroGraphic);
        try {
            this.pusherGraphic = new PusherGraphic(rampPanel, this.blockGraphic.getObjectGraphic(), this);
            this.addChild(this.pusherGraphic);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.measuringTape = new MeasuringTape(rampPanel, this.rampGraphic.getScreenTransform(), RectangleUtils.getCenter2D(this.rampGraphic.getScreenTransform().getModelBounds()));
        this.measuringTape.setVisible(false);
        this.addChild(this.measuringTape);
        this.setPotentialEnergyZeroGraphicVisible(false);
    }

    void updateArrowSetGraphics() {
        for (int i = 0; i < this.arrowSets.size(); ++i) {
            AbstractArrowSet abstractArrowSet = (AbstractArrowSet)this.arrowSets.get(i);
            abstractArrowSet.updateGraphics();
        }
    }

    public BlockGraphic getBlockGraphic() {
        return this.blockGraphic;
    }

    public void setCartesianArrowsVisible(boolean bl) {
        this.cartesian.setVisible(bl);
    }

    public void setParallelArrowsVisible(boolean bl) {
        this.parallel.setVisible(bl);
    }

    public void setPerpendicularArrowsVisible(boolean bl) {
        this.perp.setVisible(bl);
    }

    public void setXArrowsVisible(boolean bl) {
        this.xArrowSet.setVisible(bl);
    }

    public void setYArrowsVisible(boolean bl) {
        this.yArrowSet.setVisible(bl);
    }

    public boolean isCartesianVisible() {
        return this.cartesian.getVisible();
    }

    public boolean isParallelVisible() {
        return this.parallel.getVisible();
    }

    public boolean isPerpendicularVisible() {
        return this.perp.getVisible();
    }

    public boolean isXVisible() {
        return this.xArrowSet.getVisible();
    }

    public boolean isYVisible() {
        return this.yArrowSet.getVisible();
    }

    public SurfaceGraphic getRampGraphic() {
        return this.rampGraphic;
    }

    public double getBlockWidthModel() {
        int n = this.blockGraphic.getObjectWidthView();
        double d = this.rampGraphic.getScreenTransform().viewToModelDifferentialX(n);
        return d;
    }

    public double getModelWidth(int n) {
        return this.rampGraphic.getScreenTransform().viewToModelDifferentialX(n);
    }

    private void addArrowSet(AbstractArrowSet abstractArrowSet) {
        this.addChild(abstractArrowSet);
        this.arrowSets.add(abstractArrowSet);
    }

    public void setForceVisible(String string, boolean bl) {
        for (int i = 0; i < this.arrowSets.size(); ++i) {
            AbstractArrowSet abstractArrowSet = (AbstractArrowSet)this.arrowSets.get(i);
            abstractArrowSet.setForceVisible(string, bl);
        }
    }

    public int getRampBaseY() {
        Point point = this.getRampGraphic().getViewLocation(this.getRampGraphic().getSurface().getLocation(0.0));
        return point.y;
    }

    public void setMeasureTapeVisible(boolean bl) {
        this.measuringTape.setVisible(bl);
    }

    public FloorGraphic getGroundGraphic() {
        return this.groundGraphic;
    }

    public SurfaceGraphic getSurfaceGraphic(double d) {
        return this.getSurfaceGraphic(this.module.getRampPhysicalModel().getSurfaceGraphic(d));
    }

    private SurfaceGraphic getSurfaceGraphic(Surface surface) {
        if (surface == this.groundGraphic.getSurface()) {
            return this.groundGraphic;
        }
        return this.rampGraphic;
    }

    public void setHeatColor(boolean bl) {
        if (bl == this.heatColor) {
            return;
        }
        this.heatColor = bl;
        if (!bl) {
            this.restoreOriginalImages();
        } else {
            this.paintImagesRed();
        }
    }

    private void paintImagesRed() {
        if (RampPanel.redRampEnabled) {
            this.blockGraphic.paintRed();
            this.rampGraphic.paintRed();
        }
    }

    private void restoreOriginalImages() {
        this.blockGraphic.restoreOriginalImage();
        this.rampGraphic.restoreOriginalImage();
    }

    public EarthGraphic getEarthGraphic() {
        return this.earthGraphic;
    }

    public void setPotentialEnergyZeroGraphicVisible(boolean bl) {
        if (!bl && this.isPotentialEnergyZeroGraphicVisible()) {
            this.removeChild(this.potentialEnergyZeroGraphic);
        } else if (bl && !this.isPotentialEnergyZeroGraphicVisible()) {
            this.addChild(this.potentialEnergyZeroGraphic);
        }
    }

    public boolean isPotentialEnergyZeroGraphicVisible() {
        return this.getChildrenReference().contains(this.potentialEnergyZeroGraphic);
    }
}

