/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.view.RampFontSet;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.text.DecimalFormat;
import java.text.MessageFormat;

public class SpeedReadoutGraphic
extends PNode
implements ModelElement {
    private DecimalFormat format = new DecimalFormat("0.00");
    private PText phetTextGraphic;
    private RampPhysicalModel rampPhysicalModel;

    public SpeedReadoutGraphic(RampPhysicalModel rampPhysicalModel) {
        this.rampPhysicalModel = rampPhysicalModel;
        this.phetTextGraphic = new PText("");
        this.phetTextGraphic.setFont(RampFontSet.getFontSet().getSpeedReadoutFont());
        this.addChild(this.phetTextGraphic);
    }

    public void stepInTime(double d) {
        double d2 = this.rampPhysicalModel.getBlock().getVelocity();
        String string = MessageFormat.format(TheRampStrings.getString("readout.velocity"), this.format.format(d2));
        this.phetTextGraphic.setText(string);
    }
}

