/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.MakeDuotoneImageOp;
import edu.colorado.phet.common.phetcommon.view.util.PhetDefaultFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.Surface;
import edu.colorado.phet.theramp.view.AngleGraphic;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.colorado.phet.theramp.view.RampTickSetGraphic;
import edu.colorado.phet.theramp.view.SkyGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;

public class SurfaceGraphic
extends PNode {
    private RampPanel rampPanel;
    private Surface ramp;
    private ModelViewTransform2D screenTransform;
    private double viewAngle;
    private PImage surfaceGraphic;
    private PPath floorGraphic;
    private PPath bookStackGraphic;
    private int surfaceStrokeWidth = 12;
    private PPath filledShapeGraphic;
    private RampTickSetGraphic rampTickSetGraphic;
    private PText heightReadoutGraphic;
    private PPath heightExtentGraphic;
    private AngleGraphic angleGraphic;
    private BufferedImage texture;
    private Rectangle lastJackShape = null;

    public SurfaceGraphic(RampPanel rampPanel, Surface surface) {
        this.rampPanel = rampPanel;
        this.ramp = surface;
        this.screenTransform = new ModelViewTransform2D(new Rectangle2D.Double(-10.0, 0.0, 20.0, 10.0), new Rectangle(-50, -50, 800, 400));
        BasicStroke basicStroke = new BasicStroke(6.0f, 1, 1);
        try {
            this.surfaceGraphic = new PImage(this.loadRampImage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.floorGraphic = new PPath(null, basicStroke);
        this.floorGraphic.setStrokePaint(Color.black);
        Paint paint = this.createBookFill();
        this.bookStackGraphic = new PPath(null);
        this.bookStackGraphic.setStrokePaint(null);
        this.bookStackGraphic.setStroke(null);
        this.bookStackGraphic.setPaint(paint);
        this.filledShapeGraphic = new PPath();
        this.filledShapeGraphic.setPaint(Color.lightGray);
        this.filledShapeGraphic.setVisible(false);
        this.addChild(this.filledShapeGraphic);
        this.addChild(this.floorGraphic);
        this.addChild(this.bookStackGraphic);
        this.addChild(this.surfaceGraphic);
        this.heightExtentGraphic = new PPath();
        this.heightExtentGraphic.setStroke(new BasicStroke(2.0f));
        this.heightExtentGraphic.setStrokePaint(Color.black);
        this.heightExtentGraphic.setPaint(null);
        this.addChild(this.heightExtentGraphic);
        this.heightReadoutGraphic = new PText(TheRampStrings.getString("indicator.height-zero"));
        this.heightReadoutGraphic.setFont(new PhetDefaultFont(18, true));
        this.heightReadoutGraphic.setPaint(SkyGraphic.lightBlue);
        this.addChild(this.heightReadoutGraphic);
        this.surfaceGraphic.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                SurfaceGraphic.this.mouseDragged(pInputEvent);
            }
        });
        this.bookStackGraphic.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                SurfaceGraphic.this.mouseDragged(pInputEvent);
            }
        });
        this.surfaceGraphic.addInputEventListener(new CursorHandler(12));
        this.bookStackGraphic.addInputEventListener(new CursorHandler(12));
        this.rampTickSetGraphic = new RampTickSetGraphic(this);
        this.addChild(this.rampTickSetGraphic);
        this.angleGraphic = new AngleGraphic(this);
        this.addChild(this.angleGraphic);
        this.updateRamp();
        surface.addObserver(new SimpleObserver(){

            public void update() {
                SurfaceGraphic.this.updateRamp();
            }
        });
    }

    private BufferedImage loadRampImage() throws IOException {
        return ImageLoader.loadBufferedImage("the-ramp/images/wood5.png");
    }

    public PText getHeightReadoutGraphic() {
        return this.heightReadoutGraphic;
    }

    private void mouseDragged(PInputEvent pInputEvent) {
        Point2D point2D = pInputEvent.getCanvasPosition();
        Point point = this.getViewOrigin();
        this.localToGlobal(point);
        this.rampPanel.getCamera().globalToLocal(point);
        Vector2D.Double double_ = new Vector2D.Double(point, point2D);
        System.out.println("vec = " + double_);
        double d = -double_.getAngle();
        System.out.println("angle = " + d);
        d = MathUtil.clamp(0.0, d, 1.5707963267948966);
        this.ramp.setAngle(d);
        this.rampPanel.getRampModule().record();
    }

    private Point getEndLocation() {
        return this.getViewLocation(this.ramp.getLocation(this.ramp.getLength()));
    }

    private Paint createBookFill() {
        try {
            this.texture = ImageLoader.loadBufferedImage("the-ramp/images/bookstack3.gif");
            Point point = this.getEndLocation();
            return new TexturePaint(this.texture, new Rectangle2D.Double(point.x - this.texture.getWidth() / 2, point.y, this.texture.getWidth(), this.texture.getHeight()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    public PImage getSurfaceGraphic() {
        return this.surfaceGraphic;
    }

    public AngleGraphic getAngleGraphic() {
        return this.angleGraphic;
    }

    public void paintRed() {
        if (RampPanel.redRampEnabled) {
            this.surfaceGraphic.setImage(new MakeDuotoneImageOp(new Color(255, 0, 0, 32)).filter((BufferedImage)this.surfaceGraphic.getImage(), null));
        }
    }

    public void restoreOriginalImage() {
        try {
            this.surfaceGraphic.setImage(this.loadRampImage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Point getViewOrigin() {
        Point2D point2D = this.ramp.getOrigin();
        return this.screenTransform.modelToView(point2D);
    }

    private void updateRamp() {
        Point point = this.getViewOrigin();
        Point2D point2D = this.ramp.getEndPoint();
        Point point2 = this.screenTransform.modelToView(point2D);
        this.viewAngle = Math.atan2(point2.y - point.y, point2.x - point.x);
        this.surfaceGraphic.setOffset(this.getViewOrigin());
        this.surfaceGraphic.setRotation(this.viewAngle);
        double d = this.screenTransform.viewToModelDifferentialX(this.surfaceGraphic.getImage().getWidth(null));
        this.surfaceGraphic.setScale(this.ramp.getLength() / d);
        Point point3 = new Point(point2.x, point.y);
        Line2D.Double double_ = new Line2D.Double(point, point3);
        Rectangle rectangle = this.createJackArea();
        if (this.lastJackShape == null || !rectangle.equals(this.lastJackShape)) {
            this.bookStackGraphic.setPathTo(rectangle);
            this.bookStackGraphic.setPaint(this.createBookFill());
            this.bookStackGraphic.setVisible(this.ramp.getAngle() * 360.0 / 2.0 / Math.PI < 85.0);
            this.lastJackShape = rectangle;
        }
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(point);
        doubleGeneralPath.lineTo(double_.getP2());
        doubleGeneralPath.lineTo(point2);
        doubleGeneralPath.closePath();
        this.filledShapeGraphic.setPathTo(doubleGeneralPath.getGeneralPath());
        this.heightReadoutGraphic.setOffset((int)(rectangle.getBounds().getMaxX() + 5.0), rectangle.getBounds().y + rectangle.getBounds().height / 2);
        PBounds pBounds = this.heightReadoutGraphic.getGlobalFullBounds();
        this.globalToLocal(pBounds);
        this.heightExtentGraphic.setPathToPolyline(new Point2D[]{new Point2D.Double(pBounds.getCenterX() - 5.0, double_.getP2().getY()), new Point2D.Double(pBounds.getCenterX() + 5.0, double_.getP2().getY()), new Point2D.Double(pBounds.getCenterX(), double_.getP2().getY()), new Point2D.Double(pBounds.getCenterX(), rectangle.getY()), new Point2D.Double(pBounds.getCenterX() + 5.0, rectangle.getY()), new Point2D.Double(pBounds.getCenterX() - 5.0, rectangle.getY())});
        this.heightExtentGraphic.setVisible(this.ramp.getHeight() > 0.4);
        double d2 = this.ramp.getHeight();
        String string = new DecimalFormat("0.0").format(d2);
        this.heightReadoutGraphic.setText(MessageFormat.format(TheRampStrings.getString("indicator.height-meters"), string));
        this.rampTickSetGraphic.update();
        this.angleGraphic.update();
    }

    private Rectangle createJackArea() {
        Point point = this.getViewLocation(this.ramp.getLocation(0.0));
        Point point2 = this.getViewLocation(this.ramp.getLocation(this.ramp.getLength()));
        return new Rectangle(point2.x - this.texture.getWidth() / 2, (int)((double)point2.y + (double)this.surfaceGraphic.getImage().getHeight(null) * 0.75), this.texture.getWidth(), point.y - point2.y);
    }

    public double getViewAngle() {
        return this.viewAngle;
    }

    public ModelViewTransform2D getScreenTransform() {
        return this.screenTransform;
    }

    public Surface getSurface() {
        return this.ramp;
    }

    public Point getViewLocation(Point2D point2D) {
        return this.getScreenTransform().modelToView(point2D);
    }

    public Point getViewLocation(double d) {
        return this.getViewLocation(this.ramp.getLocation(d));
    }

    public AffineTransform createTransform(double d, Dimension dimension) {
        Point point = this.getViewLocation(this.ramp.getLocation(d));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(point.x, point.y);
        affineTransform.rotate(this.getViewAngle());
        int n = 7;
        affineTransform.translate(-dimension.width / 2, -dimension.height + n);
        return affineTransform;
    }
}

