/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

public class ThresholdedPDragAdapter
extends PBasicInputEventHandler {
    private Point2D lastPressLocation;
    private long lastDragTime;
    private PBasicInputEventHandler target;
    private int thresholdX = 0;
    private int thresholdY = 0;
    private long thresholdMillis = 0L;
    private boolean isDragging = false;

    public ThresholdedPDragAdapter(PBasicInputEventHandler pBasicInputEventHandler, int n, int n2, long l) {
        this.target = pBasicInputEventHandler;
        this.thresholdX = n;
        this.thresholdY = n2;
        this.thresholdMillis = l;
    }

    public void mouseClicked(PInputEvent pInputEvent) {
        this.target.mouseClicked(pInputEvent);
    }

    public void mouseEntered(PInputEvent pInputEvent) {
        this.target.mouseEntered(pInputEvent);
    }

    public void mouseExited(PInputEvent pInputEvent) {
        this.target.mouseExited(pInputEvent);
    }

    public void mousePressed(PInputEvent pInputEvent) {
        this.lastPressLocation = pInputEvent.getCanvasPosition();
        this.target.mousePressed(pInputEvent);
        this.lastDragTime = System.currentTimeMillis();
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        this.lastPressLocation = null;
        this.target.mouseReleased(pInputEvent);
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        if (System.currentTimeMillis() - this.lastDragTime >= this.thresholdMillis) {
            this.resetDragging();
        }
        if (this.lastPressLocation == null) {
            this.lastPressLocation = pInputEvent.getCanvasPosition();
        }
        double d = Math.abs(this.lastPressLocation.getX() - pInputEvent.getCanvasPosition().getX());
        double d2 = Math.abs(this.lastPressLocation.getY() - pInputEvent.getCanvasPosition().getY());
        if (d >= (double)this.thresholdX && d2 >= (double)this.thresholdY) {
            this.isDragging = true;
        }
        if (this.isDragging) {
            this.target.mouseDragged(pInputEvent);
        }
        this.lastDragTime = System.currentTimeMillis();
    }

    public void mouseMoved(PInputEvent pInputEvent) {
        this.target.mouseMoved(pInputEvent);
    }

    public void resetDragging() {
        this.isDragging = false;
        this.lastPressLocation = null;
    }
}

