/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view.arrows;

import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.piccolophet.nodes.BoundGraphic;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.theramp.view.BlockGraphic;
import edu.colorado.phet.theramp.view.RampFontSet;
import edu.colorado.phet.theramp.view.RampWorld;
import edu.colorado.phet.theramp.view.arrows.AbstractArrowSet;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ForceArrowGraphic
extends PNode {
    private double arrowTailWidth = 7.0;
    private double arrowHeadHeight = 14.0;
    private String name;
    private Color color;
    private int dy;
    private AbstractArrowSet.ForceComponent forceComponent;
    private HTMLNode textGraphic;
    private PPath shapeGraphic;
    private final Font font = RampFontSet.getFontSet().getForceArrowLabelFont();
    private Arrow lastArrow;
    private BlockGraphic blockGraphic;
    private boolean userVisible = true;
    private boolean nonZero = true;
    private String sub;
    private Color baseColor;
    private double verticalOffset = 0.0;
    private int textOffset = 30;
    private int boundGraphicInsetX = 2;
    private double boundGraphicInsetY = 0.0;

    public ForceArrowGraphic(Component component, String string, Color color, int n, AbstractArrowSet.ForceComponent forceComponent, BlockGraphic blockGraphic) {
        this(component, string, color, n, forceComponent, blockGraphic, null);
    }

    public ForceArrowGraphic(Component component, String string, Color color, int n, AbstractArrowSet.ForceComponent forceComponent, BlockGraphic blockGraphic, String string2) {
        if (string.equals(AbstractArrowSet.TOTAL)) {
            this.verticalOffset = 30.0;
        }
        if (string.equals(AbstractArrowSet.WALL)) {
            this.verticalOffset = -30.0;
        }
        this.blockGraphic = blockGraphic;
        this.name = string;
        this.baseColor = color;
        this.sub = string2;
        if (string2 != null && !string2.trim().equals("")) {
            string = "<html>" + string + "<sub>" + string2 + "</sub></html>";
        }
        this.color = this.baseColor;
        this.dy = n;
        this.forceComponent = forceComponent;
        this.textGraphic = new HTMLNode(string);
        this.textGraphic.setFont(this.font);
        this.textGraphic.setHTMLColor(Color.black);
        this.shapeGraphic = new PPath(null);
        this.shapeGraphic.setPaint(this.color);
        this.addChild(this.shapeGraphic);
        BoundGraphic boundGraphic = new BoundGraphic(this.textGraphic, this.boundGraphicInsetX, this.boundGraphicInsetY);
        boundGraphic.setPaint(Color.white);
        this.addChild(boundGraphic);
        this.addChild(this.textGraphic);
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.update();
    }

    public void update() {
        AbstractVector2D abstractVector2D = new ImmutableVector2D.Double(this.forceComponent.getForce());
        if ((abstractVector2D = abstractVector2D.getScaledInstance(0.06)).getMagnitude() <= 1.0E-7) {
            this.setVisible(false);
            this.nonZero = false;
            return;
        }
        this.nonZero = true;
        this.setVisible(this.userVisible);
        RampWorld rampWorld = this.getRampWorld();
        if (rampWorld == null) {
            return;
        }
        Point2D point2D = this.blockGraphic.getBlockBounds().getCenter2D();
        Point2D point2D2 = new Point2D.Double(point2D.getX(), point2D.getY());
        point2D2 = this.offsetTail(point2D2);
        Point2D point2D3 = abstractVector2D.getDestination(point2D2);
        Arrow arrow = new Arrow(point2D2, point2D3, this.arrowHeadHeight, this.arrowHeadHeight, this.arrowTailWidth, 0.5, false);
        GeneralPath generalPath = arrow.getShape();
        if (this.lastArrow == null || !this.lastArrow.equals(arrow)) {
            this.shapeGraphic.setPathTo(generalPath);
            AbstractVector2D abstractVector2D2 = abstractVector2D.getInstanceOfMagnitude(abstractVector2D.getMagnitude() + (double)this.textOffset);
            Point2D point2D4 = abstractVector2D2.getDestination(point2D2);
            this.textGraphic.setOffset(point2D4.getX() - this.textGraphic.getFullBounds().getWidth() / 2.0, point2D4.getY() - this.textGraphic.getFullBounds().getHeight() / 2.0);
        }
        this.lastArrow = arrow;
    }

    private Point2D offsetTail(Point2D point2D) {
        double d = this.blockGraphic.getCurrentSurfaceGraphic().getViewAngle();
        AbstractVector2D abstractVector2D = Vector2D.Double.parseAngleAndMagnitude(this.verticalOffset, d);
        abstractVector2D = abstractVector2D.getNormalVector();
        return abstractVector2D.getDestination(point2D);
    }

    private RampWorld getRampWorld() {
        for (PNode pNode = this.getParent(); pNode != null; pNode = pNode.getParent()) {
            if (!(pNode instanceof RampWorld)) continue;
            return (RampWorld)pNode;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setUserVisible(boolean bl) {
        this.userVisible = bl;
        this.setVisible(bl && this.nonZero);
    }

    public void setPaint(Paint paint) {
        this.shapeGraphic.setPaint(paint);
    }

    public Color getBaseColor() {
        return this.baseColor;
    }
}

