/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view.arrows;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.view.BlockGraphic;
import edu.colorado.phet.theramp.view.RampLookAndFeel;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.colorado.phet.theramp.view.arrows.AbstractArrowSet;
import edu.colorado.phet.theramp.view.arrows.ForceArrowGraphic;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class XArrowSet
extends AbstractArrowSet {
    public XArrowSet(RampPanel rampPanel, BlockGraphic blockGraphic) {
        super(rampPanel, blockGraphic);
        RampLookAndFeel rampLookAndFeel = new RampLookAndFeel();
        String string = TheRampStrings.getString("coordinates.x");
        final RampPhysicalModel rampPhysicalModel = rampPanel.getRampModule().getRampPhysicalModel();
        ForceArrowGraphic forceArrowGraphic = new ForceArrowGraphic(rampPanel, APPLIED, rampLookAndFeel.getAppliedForceColor(), 0, new AbstractArrowSet.ForceComponent(){

            public Vector2D getForce() {
                RampPhysicalModel.ForceVector forceVector = rampPhysicalModel.getAppliedForce();
                return forceVector.toXVector();
            }
        }, this.getBlockGraphic(), string);
        ForceArrowGraphic forceArrowGraphic2 = new ForceArrowGraphic(rampPanel, TOTAL, rampLookAndFeel.getNetForceColor(), this.getDefaultOffsetDY(), new AbstractArrowSet.ForceComponent(){

            public Vector2D getForce() {
                RampPhysicalModel.ForceVector forceVector = rampPhysicalModel.getTotalForce();
                return forceVector.toXVector();
            }
        }, this.getBlockGraphic(), string);
        ForceArrowGraphic forceArrowGraphic3 = new ForceArrowGraphic(rampPanel, FRICTION, rampLookAndFeel.getFrictionForceColor(), 0, new AbstractArrowSet.ForceComponent(){

            public Vector2D getForce() {
                RampPhysicalModel.ForceVector forceVector = rampPhysicalModel.getFrictionForce();
                return forceVector.toXVector();
            }
        }, this.getBlockGraphic(), string);
        ForceArrowGraphic forceArrowGraphic4 = new ForceArrowGraphic(rampPanel, WEIGHT, rampLookAndFeel.getWeightColor(), 0, new AbstractArrowSet.ForceComponent(){

            public Vector2D getForce() {
                RampPhysicalModel.ForceVector forceVector = rampPhysicalModel.getGravityForce();
                return forceVector.toXVector();
            }
        }, this.getBlockGraphic(), string);
        ForceArrowGraphic forceArrowGraphic5 = new ForceArrowGraphic(rampPanel, NORMAL, rampLookAndFeel.getNormalColor(), 0, new AbstractArrowSet.ForceComponent(){

            public Vector2D getForce() {
                RampPhysicalModel.ForceVector forceVector = rampPhysicalModel.getNormalForce();
                return forceVector.toXVector();
            }
        }, this.getBlockGraphic(), string);
        ForceArrowGraphic forceArrowGraphic6 = new ForceArrowGraphic(rampPanel, WALL, rampLookAndFeel.getWallForceColor(), this.getDefaultOffsetDY(), new AbstractArrowSet.ForceComponent(){

            public Vector2D getForce() {
                RampPhysicalModel.ForceVector forceVector = rampPhysicalModel.getWallForce();
                return forceVector.toXVector();
            }
        }, this.getBlockGraphic(), string);
        this.addForceArrowGraphic(forceArrowGraphic4);
        this.addForceArrowGraphic(forceArrowGraphic5);
        this.addForceArrowGraphic(forceArrowGraphic3);
        this.addForceArrowGraphic(forceArrowGraphic);
        this.addForceArrowGraphic(forceArrowGraphic6);
        this.addForceArrowGraphic(forceArrowGraphic2);
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    private Paint createXPaint(ForceArrowGraphic forceArrowGraphic) {
        int n;
        int n2 = n = 6;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = new Color(255, 255, 255);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(forceArrowGraphic.getBaseColor());
        int n3 = 2;
        graphics2D.fillRect(0, 0, n3, n2);
        return new TexturePaint(bufferedImage, new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    protected void addForceArrowGraphic(ForceArrowGraphic forceArrowGraphic) {
        super.addForceArrowGraphic(forceArrowGraphic);
        forceArrowGraphic.setPaint(this.createXPaint(forceArrowGraphic));
    }
}

