/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view.bars;

import edu.colorado.phet.common.phetcommon.math.ModelViewTransform1D;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.colorado.phet.theramp.view.bars.BarGraphSet;
import edu.colorado.phet.theramp.view.bars.EnergyBarGraphSet;
import edu.colorado.phet.theramp.view.bars.WorkBarGraphSet;
import edu.umd.cs.piccolo.PNode;

public class BarGraphSuite
extends PNode {
    private RampPanel rampPanel;
    private RampPhysicalModel rampPhysicalModel;
    private BarGraphSet workBarGraphSet;
    private BarGraphSet energyBarGraphSet;
    private ModelViewTransform1D transform1D;

    public BarGraphSuite(RampPanel rampPanel, RampPhysicalModel rampPhysicalModel) {
        this.rampPanel = rampPanel;
        this.rampPhysicalModel = rampPhysicalModel;
        this.transform1D = new ModelViewTransform1D(0.0, 600.0, 0, 3);
        this.workBarGraphSet = new WorkBarGraphSet(rampPanel, rampPhysicalModel, this.transform1D);
        this.energyBarGraphSet = new EnergyBarGraphSet(rampPanel, rampPhysicalModel, this.transform1D);
        this.addChild(this.workBarGraphSet);
        this.addChild(this.energyBarGraphSet);
        this.energyBarGraphSet.translate(this.workBarGraphSet.getFullBounds().getWidth() + 0.0, 0.0);
    }

    public void setEnergyBarsMaximized(boolean bl) {
        this.energyBarGraphSet.setMinimized(!bl);
    }

    public void setWorkBarsMaximized(boolean bl) {
        this.workBarGraphSet.setMinimized(!bl);
    }

    public boolean getEnergyBarsMaximized() {
        return !this.energyBarGraphSet.isMinimized();
    }

    public boolean getWorkBarsMaximized() {
        return !this.workBarGraphSet.isMinimized();
    }

    public double getMaxDisplayableEnergy() {
        return this.energyBarGraphSet.getMaxDisplayableEnergy();
    }

    public boolean areBothMinimized() {
        return !this.getWorkBarsMaximized() && !this.getEnergyBarsMaximized();
    }

    public void setBarChartHeight(double d) {
        this.workBarGraphSet.setBarChartHeight(d);
        this.energyBarGraphSet.setBarChartHeight(d);
    }
}

