/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view.plot;

import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.model.ValueAccessor;
import edu.colorado.phet.theramp.timeseries_ramp.TimePoint;
import edu.colorado.phet.theramp.timeseries_ramp.TimeSeries;
import edu.colorado.phet.theramp.view.plot.TimePlotSuitePNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;

public class TimeSeriesPNode {
    private TimePlotSuitePNode plotSuite;
    private ValueAccessor valueAccessor;
    private Color color;
    private String justifyString;
    private TimeSeries series;
    private Point2D.Double lastScreenPoint;
    private int strokeSize = 3;
    private Stroke stroke;
    private Color transparentColor;
    private boolean visible = true;
    private DecimalFormat decimalFormat;
    private HTMLLabel htmlLabel;
    private double lastUpdateValue = Double.NaN;

    public TimeSeriesPNode(TimePlotSuitePNode timePlotSuitePNode, TimeSeries timeSeries, ValueAccessor valueAccessor, Color color, String string) {
        this.plotSuite = timePlotSuitePNode;
        this.series = timeSeries;
        this.valueAccessor = valueAccessor;
        this.color = color;
        this.justifyString = string;
        timeSeries.addObserver(new TimeSeries.Observer(){

            public void dataAdded() {
                TimeSeriesPNode.this.dataAdded();
            }

            public void cleared() {
                TimeSeriesPNode.this.reset();
            }
        });
        this.stroke = new BasicStroke(this.strokeSize, 1, 0, 1.0f);
        this.transparentColor = new Color(color.getRGB());
        this.decimalFormat = new DecimalFormat("0.00");
        String string2 = "<html>";
        string2 = string2 + valueAccessor.getHTML() + " = ";
        string2 = string2 + "</html>";
        this.htmlLabel = new HTMLLabel(string2, color, TimeSeriesPNode.createDefaultFont(), 2);
        this.updateReadout();
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public static Font createDefaultFont() {
        return new Font("Lucida Sans", 1, 13);
    }

    void updateReadout() {
        this.updateReadout(this.valueAccessor.getValue(this.getRampPhysicalModel()));
    }

    private RampPhysicalModel getRampPhysicalModel() {
        return this.plotSuite.getRampModule().getRampPhysicalModel();
    }

    private void updateReadout(double d) {
        if (this.lastUpdateValue != d) {
            this.lastUpdateValue = d;
            this.htmlLabel.setValue(this.decimalFormat.format(d) + " " + this.valueAccessor.getUnitsAbbreviation());
        }
    }

    private void dataAdded() {
        TimePoint timePoint = this.series.getLastPoint();
        this.addPoint(timePoint);
        this.updateReadout(timePoint.getValue());
    }

    private void addPoint(TimePoint timePoint) {
        BufferedImage bufferedImage = this.plotSuite.getChartImage();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point2D point2D = this.plotSuite.toImageLocation(timePoint.getTime(), timePoint.getValue());
        if (this.lastScreenPoint != null && this.visible) {
            Line2D.Double double_ = new Line2D.Double(this.lastScreenPoint, point2D);
            graphics2D.setColor(this.transparentColor);
            graphics2D.setClip(this.plotSuite.getDataArea());
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(double_);
            Rectangle2D rectangle2D = double_.getBounds2D();
            rectangle2D = RectangleUtils.expand(rectangle2D, this.strokeSize / 2 + 2, this.strokeSize / 2 + 2);
            this.plotSuite.repaintImage(rectangle2D);
        }
        this.lastScreenPoint = new Point2D.Double(point2D.getX(), point2D.getY());
    }

    public void reset() {
        this.lastScreenPoint = null;
        this.updateReadout();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.htmlLabel.setVisible(bl);
    }

    public void repaintAll() {
        if (this.visible) {
            this.lastScreenPoint = null;
            for (int i = 0; i < this.series.numPoints(); ++i) {
                this.addPoint(this.series.pointAt(i));
            }
        }
    }

    public PNode getReadoutGraphic() {
        return this.htmlLabel;
    }

    private class HTMLLabel
    extends PNode {
        private ShadowHTMLNode htmlNode;
        private ShadowPText valueGraphic;
        private PImage labelAsImage;

        public HTMLLabel(String string, Color color, Font font, int n) {
            this.htmlNode = new ShadowHTMLNode(string);
            this.valueGraphic = new ShadowPText();
            this.setPickable(false);
            this.setChildrenPickable(false);
            this.htmlNode.setShadowOffset(1.0, 1.0);
            this.htmlNode.setShadowColor(Color.darkGray);
            this.htmlNode.setColor(color);
            this.valueGraphic.setTextPaint(color);
            this.htmlNode.setFont(font);
            this.valueGraphic.setFont(font);
            this.addChild(this.valueGraphic);
            this.valueGraphic.setOffset(this.htmlNode.getFullBounds().getWidth(), n);
            Image image = this.htmlNode.toImage();
            this.labelAsImage = new PImage(image);
            this.addChild(this.labelAsImage);
        }

        public void setValue(String string) {
            this.valueGraphic.setText(string);
        }
    }
}

