/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view.plot;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.Timer;

public class ZoomButton
extends JButton {
    private double value;
    private double min;
    private double max;
    private ArrayList listeners = new ArrayList();

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public ZoomButton(Icon icon, double d, double d2, double d3, double d4, double d5, String string) {
        super(icon);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.min = d3;
        this.max = d4;
        this.value = d5;
        Changer changer = new Changer(d2);
        Changer changer2 = new Changer(d);
        this.addMouseListener(new RepeatClicker(changer, changer2));
        this.setToolTipText(string);
    }

    private void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.zoomChanged();
        }
    }

    static class RepeatClicker
    extends MouseAdapter {
        ActionListener smooth;
        private ActionListener discrete;
        int initDelay = 300;
        int delay = 30;
        Timer timer;
        private long pressTime;

        public RepeatClicker(ActionListener actionListener, ActionListener actionListener2) {
            this.smooth = actionListener;
            this.discrete = actionListener2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.pressTime = System.currentTimeMillis();
            this.timer = new Timer(this.delay, this.smooth);
            this.timer.setInitialDelay(this.initDelay);
            this.timer.start();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.timer != null) {
                this.timer.stop();
                long l = System.currentTimeMillis();
                if (l - this.pressTime < (long)this.initDelay) {
                    this.discrete.actionPerformed(null);
                }
            }
        }
    }

    class Changer
    implements ActionListener {
        double dz;

        public Changer(double d) {
            this.dz = d;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            double d = ZoomButton.this.value;
            ZoomButton.this.value += this.dz;
            System.out.println("value = " + ZoomButton.this.value);
            ZoomButton.this.value = MathUtil.clamp(ZoomButton.this.min, ZoomButton.this.value, ZoomButton.this.max);
            if (d != ZoomButton.this.value) {
                ZoomButton.this.notifyListeners();
            }
        }
    }

    public static interface Listener {
        public void zoomChanged();
    }
}

