/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import org.jfree.util.ObjectUtilities;

public class XYDataItem
implements Cloneable,
Comparable,
Serializable {
    private Number x;
    private Number y;

    public XYDataItem(Number x, Number y) {
        if (x == null) {
            throw new IllegalArgumentException("Null 'x' argument.");
        }
        this.x = x;
        this.y = y;
    }

    public Number getX() {
        return this.x;
    }

    public Number getY() {
        return this.y;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof XYDataItem) {
            XYDataItem dataItem = (XYDataItem)o1;
            double compare = this.x.doubleValue() - dataItem.getX().doubleValue();
            result = compare > 0.0 ? 1 : (compare < 0.0 ? -1 : 0);
        } else {
            result = 1;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYDataItem)) {
            return false;
        }
        XYDataItem that = (XYDataItem)obj;
        if (!this.x.equals(that.x)) {
            return false;
        }
        return ObjectUtilities.equal(this.y, that.y);
    }

    public int hashCode() {
        int result = this.x.hashCode();
        result = 29 * result + (this.y != null ? this.y.hashCode() : 0);
        return result;
    }
}

